---
name: quiet-quitting-guardrails
version: 1.0.0
---

# Initialization

Quiet Quitting Guardrails helps professionals maintain employment while establishing sustainable work boundaries. It provides daily checklists, risk assessment frameworks, and detection avoidance strategies to find your "performance floor"—the minimum acceptable output that keeps you employed without burning out.

## Structure

- `SKILL.md` - Main skill prompt with all capabilities, workflows, and checklists

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r quiet-quitting-guardrails/ ~/.claude/skills/quiet-quitting-guardrails/
```

### ChatGPT / Gemini / Copilot
1. Open `SKILL.md`
2. Copy content after frontmatter (everything below the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction

### GPT Builder (Custom GPT)
1. Create new GPT at https://chat.openai.com/gpts/editor
2. Paste SKILL.md content into Instructions field
3. Name: "Quiet Quitting Guardrails"
4. Description: "Maintain employment while establishing sustainable boundaries. Daily checklists for performance floor calibration, detection avoidance, and risk assessment."

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{performance_floor_target}}` | `75%` | Target percentage of maximum effort to maintain |
| `{{disengagement_timeline_weeks}}` | `8` | Weeks for gradual transition to sustainable pace |
| `{{risk_tolerance}}` | `low` | Acceptable termination risk level |
| `{{monitoring_software_active}}` | `false` | Whether employer uses activity tracking |
| `{{reputation_capital}}` | `neutral` | Your performance history (low/neutral/high) |
| `{{manager_oversight_level}}` | `medium` | How closely manager tracks your work |

## Core Capabilities

1. **Daily Minimum Assessment** - Identify Must-Do vs. Optional work
2. **Detection Avoidance** - Behaviors that trigger flags and how to avoid them
3. **Risk Assessment Matrix** - Score your termination risk and adjust strategy
4. **Gradual Disengagement** - 8-week transition plan from overwork to sustainable pace
5. **Warning Signal Detection** - Recognize yellow and red flags early
6. **Calendar Optimization** - Structure your day for controlled effort

## Example Usage

```
I'm a senior software engineer at a Fortune 500 company. I've been a top performer
for 4 years, consistently working 55+ hours/week. I'm burned out and want to reduce
to 40 hours while keeping my job and good standing. My manager is hands-off but we
have quarterly reviews. No keystroke monitoring. Help me create a daily checklist
to maintain employment while establishing sustainable boundaries.
```

## Ethical Framework

This skill assumes users want to meet the minimum requirements of their role in good faith—not deceive or undermine their employer. The goal is:
- Recovering from burnout
- Rebalancing unfair expectations
- Bridging to job transitions
- Preventing harm from overwork

---
Downloaded from [Find Skill.ai](https://findskill.ai)
