---
name: not-my-job-script
version: 1.0.0
---

# "Not My Job" Script - Initialization

Professional communication framework for declining out-of-scope requests, redirecting responsibilities, and setting workplace boundaries without damaging relationships.

## What This Skill Does

- Generates professional scripts for declining tasks outside your role
- Provides templates for redirecting requests to appropriate teams
- Helps handle scope creep from clients, colleagues, and managers
- Offers frameworks for escalating ambiguous requests
- Teaches capacity-based language instead of ability-based refusals

## Package Structure

```
not-my-job-script/
├── SKILL.md   # Main skill prompt (copy this to your AI assistant)
└── INIT.md    # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill. The main content is in `SKILL.md`.

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r not-my-job-script/ ~/.claude/skills/not-my-job-script/
```

Then reference it in your conversations by mentioning the skill name.

### ChatGPT / Claude Web / Gemini / Copilot

1. Open `SKILL.md`
2. Copy everything after the `---` frontmatter
3. Paste into your AI assistant as a system prompt or at the start of your conversation
4. Describe your situation and get tailored scripts

### Custom GPT / Claude Project

1. Create a new Custom GPT or Claude Project
2. Use the content of `SKILL.md` as the system instructions
3. Users can then ask for boundary-setting scripts directly

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{reference_document}}` | `job description` | Document to cite (SOW, job description, project charter, RACI) |
| `{{communication_medium}}` | `email` | How you're communicating (email, meeting, message) |
| `{{urgency_level}}` | `moderate` | Request urgency level (low, moderate, high) |
| `{{relationship_strength}}` | `professional` | Relationship type (peer, manager, client, direct report) |
| `{{redirect_person}}` | `[appropriate team/person]` | Who to redirect the request to |
| `{{boundary_firmness}}` | `clear` | How firm the boundary needs to be (gentle, clear, firm) |

## Quick Start Examples

### Declining a Peer Request
```
My marketing colleague keeps asking me to write SQL queries for
their campaign analytics. I'm a frontend developer. Help me decline
professionally.
```

### Handling Client Scope Creep
```
My client wants to add a mobile app to our web-only contract.
Help me write a professional response that doesn't burn the
relationship but protects our scope.
```

### Setting Boundaries with Manager
```
My manager keeps assigning me work outside my job description.
I don't want to seem difficult but I'm overwhelmed. What do I say?
```

### Breaking a Pattern
```
The same person has asked me 4 times this month to do their
reports. Help me address the pattern without being confrontational.
```

## Key Frameworks

### PEACE Framework
- **P**ause: Don't respond immediately
- **E**mpathize: Acknowledge their need
- **A**ssert: State your boundary
- **C**larify: Explain where it should go
- **E**xit: Offer limited help within scope

### Capacity vs. Ability Language
| Avoid | Use Instead |
|-------|-------------|
| "I can't do that" | "I don't have the bandwidth" |
| "That's not my skill" | "My focus is on [X]" |
| "I'm not able to" | "I'm at capacity" |

## Best Use Cases

1. **Declining tasks outside your job description**
2. **Redirecting requests to the appropriate team**
3. **Handling scope creep from clients**
4. **Setting expectations with new managers**
5. **Breaking patterns of repeated boundary violations**
6. **Responding to urgent but out-of-scope requests**
7. **Escalating ambiguous ownership situations**
8. **Walking back over-commitments**

## Related Skills

- [Assertive Communication Coach](/skills/productivity/assertive-communication-coach/)
- [Difficult Workplace Conversations](/skills/productivity/difficult-workplace-conversations/)
- [Managing Up Communication Coach](/skills/productivity/managing-up-coach/)
- [Toxic Boss Decoder](/skills/workplace-survival/toxic-boss-decoder/)

## Troubleshooting

**"I feel guilty saying no"**
→ Reframe as "yes to the right person." You're ensuring the request gets to someone who can actually help.

**"My manager expects me to say yes to everything"**
→ Ask for prioritization guidance: "Which should take priority: [new request] or [current work]?"

**"The same person keeps ignoring my boundaries"**
→ Document the pattern and escalate to your manager.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
