---
name: layoff-go-bag-packer
version: 1.0.0
---

# Initialization

Generate prioritized, legally-aware checklists of critical documents, contacts, and records to preserve before losing system access during layoff, termination, or resignation. Time-sensitive guidance for protecting your career and financial future.

## Structure

- `SKILL.md` - Main skill prompt with complete emergency checklists, regional variations, severance prep, and evidence collection modes

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r layoff-go-bag-packer/ ~/.claude/skills/layoff-go-bag-packer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (starting from "You are an expert Layoff Go Bag Packer...")
3. Paste into your AI assistant's custom instructions or as a system prompt

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{employment_years}}` | `5` | Years at company; affects document volume and severance expectations |
| `{{employment_type}}` | `full_time_salaried` | Type of employment (full_time_salaried, hourly, contractor) |
| `{{region}}` | `US` | Geographic region for country-specific forms (US, Canada, UK, EU, India) |
| `{{compensation_structure}}` | `salary_only` | Pay structure (salary_only, salary_plus_bonus, salary_plus_equity) |
| `{{suspected_wrongful_termination}}` | `false` | Enable legal evidence collection mode |
| `{{needs_income_verification}}` | `false` | Prioritize pay docs for loans/rent/immigration |

## Quick Start

After installing, try these prompts:

**Emergency Mode (same-day):**
> "I just got laid off with same-day notice in the U.S. and my email will be cut off in 2 hours. I've been here 4 years on salary plus RSUs. Generate a minute-by-minute checklist of exactly what to save and in what order before I lose access."

**Proactive Preparation:**
> "I've heard rumors about layoffs at my company. I'm a full-time employee in Canada with 3 years tenure, salary plus annual bonus. Help me create a weekly backup routine so I'm prepared if it happens."

**Wrongful Termination Concern:**
> "I'm in Canada and was told I'll be laid off next week. I think they are targeting me after I raised issues about harassment. Help me build a legally safe 'go bag' of documents and a timeline I can use with a lawyer."

**International (India):**
> "I'm resigning from my job in India after 7 years. I want to ensure I have all the right letters, payslips, and Form 16s for future employers and visas. Create a detailed export checklist tailored to India."

## Features

- **Emergency checklists** prioritized by time (30 min, 1 hr, 2 hr tiers)
- **Regional variations** for US, Canada, UK/EU, and India
- **Severance negotiation prep** with leverage points and questions
- **Legal evidence mode** for suspected wrongful termination
- **Portfolio preservation** guidance (what's safe vs. risky)
- **Benefits transition** coverage (COBRA, 401k, HSA/FSA, EI, ROE)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
