---
name: sunday-scaries-protocol
version: 1.0.0
---

# Sunday Scaries Protocol - Initialization

A structured 4 PM Sunday transition routine that eliminates Monday morning dread through CBT journaling, breathwork, meal prep, and strategic planning.

## What This Skill Does

Transforms Sunday evening anxiety into productive preparation by combining:
- Cognitive behavioral therapy (CBT) worry containment techniques
- Parasympathetic activation through structured breathwork
- Physical preparation to eliminate Monday friction
- Strategic weekly planning to reduce uncertainty
- Sleep optimization for better Sunday night rest

## Package Structure

```
sunday-scaries-protocol/
├── SKILL.md      # Main skill prompt (copy to AI assistant)
└── INIT.md       # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code (Recommended)

```bash
# Copy skill to Claude Code skills directory
cp -r sunday-scaries-protocol/ ~/.claude/skills/sunday-scaries-protocol/
```

Then reference in your project's `CLAUDE.md`:

```markdown
## Available Skills

| Skill | Use When |
|-------|----------|
| `sunday-scaries-protocol` | User experiencing work-related Sunday anxiety |
```

### ChatGPT / Custom GPTs

1. Open ChatGPT
2. Go to "Explore GPTs" → "Create"
3. In the "Instructions" field, paste the entire contents of `SKILL.md` (after the frontmatter `---`)
4. Name your GPT "Sunday Scaries Coach" or similar
5. Save and use

### Claude.ai (Web)

1. Start a new conversation
2. Click "Add context" or use the paperclip
3. Paste the contents of `SKILL.md` (after the frontmatter)
4. Or simply copy/paste the skill content as your first message

### Gemini

1. Open Google AI Studio or Gemini
2. In System Instructions, paste the contents of `SKILL.md`
3. Start conversation with your Sunday anxiety concerns

### Copilot

1. Open Microsoft Copilot
2. Paste the skill content as context in your conversation
3. Follow with your specific situation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `protocol_start_time` | `4:00 PM` | When to begin Sunday transition (3-5 PM optimal) |
| `breathing_pattern` | `4-7-8` | Breathwork: 4-7-8, box-4-4-4-4, or simple-5-count |
| `meal_prep_complexity` | `simple` | Prep level: minimal, simple, or moderate |
| `journaling_duration` | `15 minutes` | Worry-time session length (10-20 min) |
| `monday_reward_type` | `meal` | Motivational anchor type |
| `grounding_technique` | `5-4-3-2-1` | Sensory grounding method |

## Quick Start Examples

### Basic Usage
```
"I have intense Sunday evening anxiety about work. Help me set up a Sunday Scaries Protocol for my situation."
```

### With Context
```
"I'm a remote software engineer and I start dreading Monday around 3 PM on Sunday. I can't sleep well Sunday nights and Monday mornings feel overwhelming. What's the best protocol for someone who works from home?"
```

### Customization Request
```
"I only have 20 minutes on Sunday afternoon for anxiety management. What's the minimum viable Sunday Scaries Protocol I can do?"
```

### Impostor Syndrome Focus
```
"My Sunday Scaries are mostly about feeling like a fraud at work. Even though my reviews are good, I keep expecting to be exposed. How do I customize the worry-time journaling for impostor syndrome?"
```

## Protocol Components

The skill provides six core phases:

1. **Transition Signal** (10 min) - Quick win task to shift mindset
2. **Grounding Exercise** (5 min) - 5-4-3-2-1 sensory technique
3. **Strategic Planning** (10 min) - Calendar review and task prioritization
4. **Worry Time Journaling** (15 min) - CBT-based thought containment
5. **Breathwork** (5 min) - Parasympathetic nervous system activation
6. **Physical Preparation** (15 min) - Outfit, bag, workspace setup

Plus optional modules:
- Meal prep (20-90 min)
- Sleep optimization sequence
- Monday morning anchor
- Friday mini-protocol

## Expected Outputs

The AI will provide:
- Personalized assessment based on your work situation
- Step-by-step protocol with exact timing
- CBT journaling framework with distortion identification
- Breathwork instruction matched to experience level
- Customization recommendations for your user type
- Troubleshooting for common obstacles
- Progress tracking metrics

## Customization Profiles

The skill adapts for:
- Remote workers (transition rituals)
- High-stakes roles (extended planning)
- Impostor syndrome sufferers (evidence gathering)
- Anxiety disorder management (therapy integration)
- New job/probation (controllables focus)

## Success Metrics

After 4 weeks of consistent use:
- Sunday anxiety rating decreased 2+ points
- Fall asleep within 30 minutes Sunday night
- Monday mornings feel "manageable" vs. dreadful
- Reduced avoidance behaviors (clock-watching, rumination)

## Related Skills

- Stress Management - General work stress techniques
- Anxiety Spirals Interrupter - Real-time panic intervention
- Cognitive Reframing Guide - CBT thought transformation
- Sleep Optimizer - Comprehensive sleep improvement
- Habit Tracker - Protocol habit formation

## Support

For issues or feedback:
- Visit [Find Skill.ai](https://findskill.ai)
- Browse related skills in the Wellbeing category

---
Downloaded from [Find Skill.ai](https://findskill.ai)
