---
name: rejection-sensitivity-soother
version: 1.0.0
---

# Rejection Sensitivity Soother

CBT/DBT-based cognitive reframing coach to manage rejection sensitivity dysphoria (RSD) in digital communication. Helps users reframe one-word texts, missing emojis, delayed responses, and ambiguous tone using evidence-based techniques.

## Who This Is For

- **Primary:** Individuals with ADHD who experience RSD
- **Secondary:** People with anxiety disorders, BPD, or attachment concerns
- **Anyone** who spirals over text tone, delayed responses, or "k" replies

## Structure

```
rejection-sensitivity-soother/
├── SKILL.md     # Main skill prompt (comprehensive CBT/DBT guide)
└── INIT.md      # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r rejection-sensitivity-soother/ ~/.claude/skills/rejection-sensitivity-soother/
```

### ChatGPT / Gemini / Copilot
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's custom instructions or conversation

### As a System Prompt
Copy the entire content of `SKILL.md` and use as a system prompt for any LLM.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{trigger_intensity_threshold}}` | `7` | Emotional intensity (1-10) above which to use TIPP skills before cognitive work |
| `{{response_delay_tolerance}}` | `24 hours` | Recommended wait time before responding to triggering messages |
| `{{communication_style_profile}}` | `neutral` | User's baseline expectation: warm, neutral, or mixed |
| `{{validation_language_preference}}` | `acceptance_based` | Affirmation style: acceptance_based or compassion_based |
| `{{distress_tolerance_modality}}` | `temperature` | Preferred TIPP skill: temperature, intense_exercise, paced_breathing, muscle_relaxation |

## Quick Variable Customization

If you frequently experience high-intensity reactions, consider:
- Setting `trigger_intensity_threshold` to `5` (more aggressive distress tolerance)
- Setting `distress_tolerance_modality` to your preferred grounding technique

If you prefer warmer, more nurturing language:
- Set `validation_language_preference` to `compassion_based`

## Key Techniques Included

1. **ABC Model** - Activating Event → Belief → Consequence
2. **10 Cognitive Distortions** - Mind reading, fortune telling, catastrophizing, etc.
3. **TIPP Skills** - Temperature, Intense exercise, Paced breathing, Progressive relaxation
4. **5-4-3-2-1 Grounding** - Sensory-based present-moment anchoring
5. **RAIN Meditation** - Recognize, Allow, Investigate, Nurture
6. **DEAR MAN / GIVE / FAST** - DBT interpersonal effectiveness frameworks
7. **Alternative Explanation Generator** - Pre-loaded neutral interpretations
8. **Evidence Bank** - Tracking past false-rejection experiences

## Example Usage

**Trigger:** "My partner usually texts 'Good morning!' but today just sent 'morning.' I've been upset all day."

**Response Pattern:**
1. Validate: "It makes sense that you'd notice this change."
2. Assess: "How distressed are you right now, 1-10?"
3. Ground (if needed): TIPP or 5-4-3-2-1
4. Identify distortion: Personalization, mind reading
5. Generate alternatives: Tired, autocorrect, phone typing, no meaning
6. Reframe: "Emojis are style markers, not friendship indicators."
7. Action: Wait, don't text "are you mad at me?"

## Research Foundation

This skill synthesizes techniques from:
- **CBT** (Cognitive Behavioral Therapy) - thought records, distortion identification
- **DBT** (Dialectical Behavior Therapy) - distress tolerance, TIPP, interpersonal effectiveness
- **REBT** (Rational Emotive Behavior Therapy) - ABC model, disputation
- **RSD Research** - Rejection Sensitivity Dysphoria literature, especially ADHD-related

## Limitations

This skill:
- Does NOT diagnose ADHD, anxiety, or any condition
- Does NOT replace professional therapy or medication
- Does NOT fix toxic or abusive relationships
- Does NOT guarantee others will change their communication style

If experiencing severe distress, please consult a mental health professional.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
