---
name: negative-self-talk-flipper
version: 1.0.0
---

# Negative Self-Talk Flipper - Initialization

Transform harsh self-criticism into compassionate, growth-oriented thoughts using CBT-based cognitive restructuring and evidence-based reframing techniques.

## What This Skill Does

The Negative Self-Talk Flipper helps you:
- Identify cognitive distortions in your self-critical thoughts
- Transform statements like "I'm an idiot" into "I made a mistake I can learn from"
- Apply evidence-based CBT techniques to challenge negative thinking
- Build self-compassion and growth mindset patterns
- Interrupt negative thought spirals in real-time

## Package Structure

```
negative-self-talk-flipper/
├── SKILL.md   # Main skill prompt (copy this to your AI)
└── INIT.md    # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code (Recommended)

```bash
# Copy the skill folder to your Claude skills directory
cp -r negative-self-talk-flipper/ ~/.claude/skills/negative-self-talk-flipper/

# The skill is now available in Claude Code
```

### Claude Projects

1. Open your Claude Project
2. Go to Project Knowledge
3. Upload `SKILL.md`
4. The skill is now available in that project

### ChatGPT Custom Instructions

1. Open `SKILL.md`
2. Copy everything after the `---` frontmatter delimiter
3. Paste into ChatGPT's Custom Instructions or a new GPT's system prompt

### Other AI Assistants (Gemini, Copilot, etc.)

1. Open `SKILL.md`
2. Copy the content after the frontmatter
3. Paste as the first message or system context

## Quick Start

After installation, try these prompts:

**Basic reframe:**
```
"I totally failed that presentation. I'm such an idiot."
```

**Pattern recognition:**
```
"I keep having these thoughts: 'I'm not good enough', 'Everyone thinks I'm incompetent', 'I'll never succeed'. Can you help me see the pattern?"
```

**Evidence-based challenge:**
```
"Help me challenge this thought with evidence: 'My boss didn't respond to my email, so she must hate my work.'"
```

**Self-compassion focus:**
```
"I'm being really hard on myself about a social mistake. Can you help me be kinder to myself?"
```

## Variables

| Variable | Default | Options | Description |
|----------|---------|---------|-------------|
| `intensity_level` | `compassionate` | gentle, compassionate, realistic, action-focused, growth-oriented | Tone and intensity of the reframe |
| `evidence_depth` | `moderate` | quick, moderate, deep | How much reasoning to include |
| `reframe_type` | `balanced` | self-compassion, balanced, growth-mindset, problem-solving | Primary reframe approach |
| `include_distortion_labels` | `true` | true, false | Whether to name cognitive distortions |
| `include_behavioral_action` | `true` | true, false | Whether to suggest next steps |

**Using variables:**
```
"Reframe this thought with intensity_level=gentle and reframe_type=self-compassion: 'I made a mistake and everyone hates me now.'"
```

## The 10 Cognitive Distortions

This skill identifies and addresses:

1. **All-or-Nothing Thinking** - Viewing things as completely good or bad
2. **Catastrophizing** - Assuming the worst outcome
3. **Labeling** - Assigning global negative labels ("I'm an idiot")
4. **Mind-Reading** - Assuming you know what others think
5. **Personalization** - Taking responsibility for things outside your control
6. **Should Statements** - Rigid perfectionist rules
7. **Emotional Reasoning** - Treating feelings as facts
8. **Fortune Telling** - Predicting the future negatively
9. **Overgeneralization** - Using "always," "never" based on limited evidence
10. **Discounting Positives** - Dismissing achievements

## Important Note

This skill is a psychological tool, not a replacement for therapy. If you're experiencing:
- Suicidal thoughts or self-harm urges
- Severe depression or inability to function
- Acute mental health crisis

Please reach out to professional resources:
- Crisis Text Line: Text HOME to 741741
- National Suicide Prevention Lifeline: 988
- International Association for Suicide Prevention: https://www.iasp.info/resources/Crisis_Centres/

## Related Skills

- [Cognitive Reframing Guide](/skills/productivity/cognitive-reframing-guide/) - Stoic + CBT general reframing
- [Anxiety Spirals Interrupter](/skills/productivity/anxiety-spirals-interrupter/) - Real-time anxiety intervention
- [Impostor Syndrome Reframer](/skills/productivity/impostor-syndrome-reframer/) - Self-doubt transformation
- [Emotional Regulation Coach](/skills/productivity/emotional-regulation-coach/) - DBT/CBT emotional management

## Research Foundation

Based on:
- Cognitive Behavioral Therapy (CBT) - Aaron Beck's cognitive model
- Self-Compassion Research - Kristin Neff's framework
- Growth Mindset - Carol Dweck's research
- Clinical validation studies showing 28.6% increase in positive affect

---
Downloaded from [Find Skill.ai](https://findskill.ai)
