---
name: gaslighting-journal
version: 1.0.0
---

# Gaslighting Journal - Initialization Guide

A structured documentation system to help abuse survivors counter psychological manipulation by creating factual, timestamped records of events to validate memory and reality.

## Overview

This skill transforms your AI assistant into a compassionate, trauma-informed documentation partner that helps you:
- Record incidents objectively in neutral, police-report-style language
- Recognize patterns of manipulation over time
- Process emotions separately from factual documentation
- Prepare legal-ready documentation if needed
- Ground yourself in reality when self-doubt creeps in

## Structure

```
gaslighting-journal/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization guide
```

## Files to Generate

None required - this is a prompt-only skill. The SKILL.md file contains everything needed.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy to Claude Code skills directory
cp -r gaslighting-journal/ ~/.claude/skills/gaslighting-journal/
```

Then reference in your project's `.claude/settings.json` or invoke directly.

### ChatGPT / GPT-4

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (everything after the second `---`)
3. Paste into ChatGPT as a custom instruction or at the start of a conversation

### Gemini

1. Open `SKILL.md`
2. Copy the skill content
3. Paste at the beginning of your conversation with context: "Use these instructions to help me document incidents"

### Copilot / Other AI Assistants

1. Open `SKILL.md`
2. Copy the skill content
3. Paste as system instructions or conversation primer

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `documentation_style` | `factual_neutral` | Either `factual_neutral` (police-report style) or `emotional_processing` (therapeutic reflection) |
| `incident_date` | `today` | The date the incident occurred (YYYY-MM-DD format) |
| `privacy_level` | `password_protected` | Storage method: `password_protected`, `physical_locked`, `backup_shared` |
| `pattern_threshold` | `3` | Number of recurring incidents to mark as established pattern |
| `review_frequency` | `monthly` | How often to review entries: `weekly`, `bi-weekly`, `monthly`, `quarterly` |
| `therapeutic_integration` | `true` | Include reflection prompts and self-validation language |

## Example Prompts

### Document a New Incident
```
I need to document an incident that happened today. My partner said I
never told them about dinner plans, but I clearly remember our
conversation this morning. I have a text I sent about it too.
```

### Pattern Analysis
```
I've been documenting incidents for 6 weeks now. Can you help me
analyze the patterns and see what tactics are being used most often?
```

### Legal Documentation
```
I need to prepare my documentation for a custody hearing. Can you
help me format my entries in a way that would be appropriate for
legal proceedings?
```

### Emotional Processing
```
I just finished documenting an incident and I'm feeling overwhelmed
with self-doubt. Can we do some emotional processing?
```

## Key Features

### 1. Incident Documentation
Structured templates for recording events objectively, including:
- Date, time, location, persons present
- Direct quotes and observable behaviors
- Supporting evidence checklist
- Physical and emotional effects

### 2. Pattern Recognition
Analyze multiple entries to identify:
- Tactic frequency (denial, reality manipulation, isolation, etc.)
- Cycle patterns (triggers, escalation, honeymoon phases)
- Validation statements based on documented evidence

### 3. Emotional Processing
Separate section for feelings, including:
- Reality checks using documented facts
- Self-compassion prompts
- Grounding techniques

### 4. Legal Format
Court-ready documentation with:
- First-person perspective
- Neutral, observable language
- Evidence correlation
- Proper timestamps

### 5. Security Guidance
Recommendations for keeping documentation safe:
- Digital security (encrypted apps, 2FA)
- Physical security (locked storage, trusted backup)
- Emergency access protocols

## Important Notes

- **Not therapy**: This is a documentation tool, not a replacement for professional mental health support
- **Safety first**: If in immediate danger, contact emergency services (911) or National Domestic Violence Hotline (1-800-799-7233)
- **Privacy critical**: Ensure documentation is stored securely and cannot be accessed by the person causing harm
- **Legal consultation**: Consult an attorney about admissibility in your jurisdiction

## Professional Resources

- **National Domestic Violence Hotline**: 1-800-799-7233
- **Trauma-informed therapists** (search: CPTSD, narcissistic abuse specialist)
- **Support communities**: r/NarcissisticAbuse, r/domesticviolence
- **Local domestic violence shelters** for safety planning

## Post-Init Steps

1. Store the skill in a secure location
2. Consider using alongside other wellbeing skills:
   - Cognitive Reframing Guide
   - Emotional Regulation Coach
   - Anxiety Spirals Interrupter
3. Connect with a trauma-informed therapist for comprehensive support
4. Establish a secure storage method before documenting

---
Downloaded from [Find Skill.ai](https://findskill.ai)
