---
name: doomscrolling-interrupter
version: 1.0.0
---

# Doomscrolling Interrupter - Initialization

An AI-powered intervention system that breaks compulsive scrolling loops with personalized 5-minute offline missions based on behavioral psychology and Attention Restoration Theory.

## What This Skill Does

When users are trapped in compulsive news or social media scrolling, this skill:

1. **Immediately interrupts** the pattern without judgment or shame
2. **Assesses energy level** (wired/anxious, numb/exhausted, mixed)
3. **Deploys specific 5-minute mission** matched to their state
4. **Builds trigger awareness** through brief reflection
5. **Creates sustainable habit replacement** (not deprivation)

## Package Structure

```
doomscrolling-interrupter/
├── SKILL.md      # Main skill prompt (copy to your AI assistant)
└── INIT.md       # This initialization file
```

## Files to Generate

None - this is a prompt-only skill. The SKILL.md file contains everything needed.

## Post-Init Steps

### For Claude Code / Claude Desktop

```bash
# Copy to Claude skills directory
cp -r doomscrolling-interrupter/ ~/.claude/skills/doomscrolling-interrupter/
```

Then add to your CLAUDE.md or project settings:
```markdown
## Available Skills
- `doomscrolling-interrupter` - Break scrolling loops with 5-minute offline missions
```

### For ChatGPT / GPT-4

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a custom instruction or at the start of a conversation
4. Or create a Custom GPT with the prompt as instructions

### For Gemini

1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Paste into Gemini at conversation start
4. Prefix with "Act as the following:" for best results

### For Copilot

1. Open `SKILL.md`
2. Copy the skill content
3. Paste into Copilot conversation
4. Start interaction with "I'm doomscrolling, help me"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `mission_duration_minutes` | `5` | Length of offline task (3-15 minutes) |
| `energy_level` | `auto_detect` | User's energy: high, medium, low, uncertain |
| `mission_category_preference` | `all` | Types: nature, sensory, creative, physical, social, cognitive |
| `environment_context` | `flexible` | Setting: office, home, outdoors, public |
| `trigger_awareness_depth` | `basic` | Reflection: basic, moderate, deep |
| `gamification_mode` | `streaks_only` | Accountability: streaks, badges, leaderboard, none |

## Example Usage

**Emergency Interrupt:**
```
"I just realized I've been scrolling through news for 45 minutes and I feel terrible. Help me break this cycle right now."
```

**Preventative Setup:**
```
"I want to set up a daily routine to prevent doomscrolling. I usually scroll most between 4-6pm after work."
```

**Acute Anxiety:**
```
"I'm reading about [news event] and I'm spiraling. My chest is tight and I can't stop. Help."
```

## Mission Categories

| Type | Best For | Examples |
|------|----------|----------|
| **Nature** | Attention fatigue | Step outside, window observation, plant examination |
| **Sensory** | Grounding needed | Cold water reset, texture hunt, sound mapping |
| **Physical** | Wired/anxious | Shake it off, walk circuits, stretching |
| **Cognitive** | Need engagement | Color scavenger hunt, object stories |
| **Grounding** | Acute anxiety | 5-4-3-2-1, box breathing, counting exhales |

## Key Differentiator

Unlike apps that just block or shame, this skill provides **immediate alternative activities** designed by behavioral psychology. It replaces the scroll with something better, not nothing.

## Related Skills

- **Digital Detox Planner** - Long-term screen time reduction (use this skill for immediate intervention, that for planning)
- **Anxiety Spirals Interrupter** - CBT-based anxiety intervention
- **Stress Management** - Evidence-based stress reduction techniques
- **Habit Stacking Architect** - Design replacement habit chains

## Research Foundation

Based on:
- Attention Restoration Theory (ART)
- Cognitive Behavioral Therapy (CBT) principles
- Behavioral Activation techniques
- Micro-break research
- Habit formation science

---
Downloaded from [Find Skill.ai](https://findskill.ai)
