---
name: design-system-architect
version: 1.0.0
---

# Initialization

Create comprehensive design systems with tokens, components, patterns, and documentation. Build scalable, consistent UI foundations for web and mobile apps.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r design-system-architect/ ~/.claude/skills/design-system-architect/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{brand_name}}` | `Acme` | Your brand or product name |
| `{{primary_color}}` | `#3B82F6` | Primary brand color in hex |
| `{{design_tool}}` | `Figma` | Design tool for tokens export |
| `{{framework}}` | `React` | Frontend framework for components |
| `{{scale_type}}` | `8px grid` | Spacing/typography scale type |

## Related Skills

- [Figma Design Tokens](https://findskill.ai/skills/design-media/figma-design-tokens/)
- [Frontend Design Pro](https://findskill.ai/skills/ai-creative/frontend-design-pro/)
- [Ux Designer](https://findskill.ai/skills/ai-creative/ux-designer/)

---
Downloaded from [Find Skill.ai](https://findskill.ai)