---
name: accessible-color-palette
version: 1.0.0
---

# Initialization

Create WCAG-compliant color systems with proper contrast ratios. Generate AA/AAA palettes with dark mode support and semantic naming conventions.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r accessible-color-palette/ ~/.claude/skills/accessible-color-palette/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{primary_color}}` | `#3B82F6` | Your main brand color in hex |
| `{{brand_name}}` | `MyApp` | Your brand or product name |
| `{{compliance_level}}` | `AA` | WCAG compliance target |
| `{{include_dark_mode}}` | `yes` | Generate dark mode variants |
| `{{output_format}}` | `CSS variables` | Output format for tokens |

## Related Skills

- [Design System Architect](https://findskill.ai/skills/ux-design/design-system-architect/)
- [Ux Designer](https://findskill.ai/skills/ai-creative/ux-designer/)
- [Figma Design Tokens](https://findskill.ai/skills/design-media/figma-design-tokens/)
- [Frontend Design Pro](https://findskill.ai/skills/ai-creative/frontend-design-pro/)

---
Downloaded from [Find Skill.ai](https://findskill.ai)