---
name: wedding-life-event-coordinator
version: 1.0.0
description: Plan weddings and major life celebrations with timelines, budgets, vendor coordination, and checklists
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This is a prompt-only skill for planning weddings and other major life events. No scripts or additional files are needed - simply use SKILL.md directly with any AI assistant.

The skill helps with:
- Month-by-month wedding planning timelines
- Budget allocation and tracking by category
- Vendor interview questions and comparison
- Guest list management and seating charts
- Day-of timeline creation
- Communication templates for vendors and guests
- Baby showers, graduations, anniversaries, and retirement parties

## Directory Structure

```
wedding-life-event-coordinator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - the skill works directly from SKILL.md content.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r wedding-life-event-coordinator/ ~/.claude/skills/wedding-life-event-coordinator/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Start planning your event!

## Compatibility

Tested and optimized for:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)

## Variables

Customize these for your specific event:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{event_type}}` | wedding | Type of event (wedding, baby shower, etc.) |
| `{{event_date}}` | October 15, 2026 | When the event takes place |
| `{{guest_count}}` | 120 guests | Expected number of attendees |
| `{{total_budget}}` | $35,000 | Overall budget |
| `{{location}}` | Austin, Texas | City/region for the event |
| `{{style}}` | romantic garden party | Theme or aesthetic |
| `{{planning_help}}` | planning ourselves | With planner or DIY |

## Example Usage

After loading the skill, try prompts like:

**Full wedding planning:**
"We're planning a wedding for October 2026, about 120 guests in Austin. Budget is $35,000 and we want a romantic garden vibe. Create a complete planning timeline, budget breakdown, and vendor checklist."

**Budget planning only:**
"Help me allocate a $25,000 wedding budget for 100 guests. We want to prioritize photography and food."

**Vendor comparison:**
"I'm interviewing photographers for my wedding. Give me the key questions to ask and what to look for in their answers."

**Day-of timeline:**
"Create a detailed wedding day timeline for a 4pm ceremony, cocktail hour, then reception until 11pm."

**Baby shower planning:**
"Help me plan a baby shower for my sister. It's in 5 weeks, expecting 25 guests, budget is $400."

**Guest management:**
"How should I handle plus-ones and seating chart for a 150-person wedding with complicated family dynamics?"

## Tips for Best Results

1. **Share all constraints upfront**: Budget, date, location, guest count
2. **Mention what's already decided**: Booked venue, chosen colors, etc.
3. **State your priorities**: What matters most to you
4. **Be clear about help level**: DIY vs. wedding planner
5. **Ask for alternatives**: Different options at different price points
6. **Request templates**: Spreadsheets, communication drafts, etc.

## Supported Events

**Weddings:**
- Traditional weddings (12+ month planning)
- Short-timeline weddings (3-6 months)
- Destination weddings
- Elopements
- Vow renewals

**Other Life Events:**
- Baby showers
- Bridal showers
- Graduation parties
- Retirement parties
- Anniversary celebrations (25th, 50th, etc.)
- Milestone birthdays
- Engagement parties

---
Downloaded from [FindSkill.ai](https://findskill.ai)
