---
name: wedding-guest-list-cutter
version: 1.0.0
---

# Initialization

A systematic framework for reducing wedding guest lists using objective, guilt-free criteria when budget or venue constraints require cuts. Provides tier systems, cost analysis, and fair rules that remove emotional bias from difficult decisions.

## Structure

- `SKILL.md` - Main skill prompt with complete framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r wedding-guest-list-cutter/ ~/.claude/skills/wedding-guest-list-cutter/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant as system prompt or conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{total_budget}}` | `$20,000` | Total wedding budget available |
| `{{per_person_cost}}` | `$150` | Estimated all-in cost per guest |
| `{{venue_capacity}}` | `120` | Maximum venue capacity |
| `{{current_list_size}}` | `185` | Current number of people on guest list |
| `{{no_show_rate}}` | `15%` | Expected percentage of declines |
| `{{child_free_policy}}` | `true` | Whether children are excluded |

## Core Capabilities

1. **A/B/C Tier System** - Categorize guests into must-have, want, and nice-to-have tiers
2. **Objective Cutting Rules** - Apply fair criteria like meal-sharing test, child-free policy, plus-one restrictions
3. **Cost-Impact Analysis** - Show financial trade-offs for different guest count scenarios
4. **Relationship Strength Scoring** - Quantify closeness using contact frequency, shared events, crisis support
5. **Cascade Reduction Strategy** - Progressive cutting from C-tier up through harder decisions
6. **Conversation Scripts** - Ready-made language for parents, relatives, friends
7. **Spreadsheet Guidance** - Recommended columns and filters for tracking

## Example Usage

```
"We have a $15k budget, catering is $140/head, and our families want to invite
200 people. Help us apply fair, objective rules (tiers, kids, plus-ones) to get
to a realistic list we can explain to our parents."
```

## Key Concepts

- **Tier System** - Private A/B/C categorization where A = must-invite, B = want, C = optional
- **Per-Person Cost** - Typically $100-200 including food, rentals, venue share
- **RSVP No-Show Rate** - Plan for 10-20% declines (usually model 15%)
- **Meal-Sharing Test** - "Have we shared a meal in the past 3 years?" as relationship filter
- **Child-Free Policy** - Adults-only (18+) or immediate-family-children-only
- **Plus-One Restrictions** - Tightening criteria (married/engaged, 1+ year relationships)
- **Parent Allocation** - Proportional guest spots based on budget contribution

---
Downloaded from [Find Skill.ai](https://findskill.ai)
