---
name: wedding-budget-reality-check
version: 1.0.0
---

# Initialization

Wedding Budget Reality Check - Transform abstract wedding budget percentages into concrete trade-off scenarios. Shows couples exactly what they can afford and what gets cut when prioritizing specific categories like venue, photography, or catering.

## Structure

```
wedding-budget-reality-check/
├── SKILL.md    # Main skill prompt (500+ lines)
└── INIT.md     # This file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
cp -r wedding-budget-reality-check/ ~/.claude/skills/wedding-budget-reality-check/
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (everything below the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction
4. Start with a budget scenario like: "We have $35k for 120 guests in Austin, TX"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{total_budget_usd}}` | `$30,000` | Total dollar amount allocated for the wedding |
| `{{guest_count_estimate}}` | `100` | Estimated number of in-person guests attending |
| `{{venue_type}}` | `restaurant` | Type of venue (hotel, garden, restaurant, barn, backyard) |
| `{{region_location}}` | `Austin, TX` | Wedding location for regional pricing adjustments |
| `{{priority_categories}}` | `photography, catering` | Top 2-3 categories to prioritize in budget |
| `{{contingency_percentage}}` | `15%` | Percentage of budget reserved for unexpected costs |

## Key Capabilities

1. **Budget Scenario Modeling**: Calculate realistic allocations based on budget, guests, and location
2. **Trade-Off Visualization**: Show exactly what gets cut when prioritizing specific categories
3. **Regional Pricing**: Apply multipliers for local costs (NYC = 2x, rural = 0.7x)
4. **Guest Count Sensitivity**: Model how 100 vs 150 guests changes the entire budget structure
5. **Priority Reallocation**: Input top priorities and see recalculated allocations
6. **Vendor Upgrade Impact**: See cascade effects of upgrading one category
7. **Timeline Assessment**: Understand how planning timeline affects costs

## Regional Multipliers Reference

| Region | Multiplier |
|--------|------------|
| NYC, SF, Boston | 2.0-2.5x |
| LA, DC, Seattle | 1.5-2.0x |
| Chicago, Miami, Denver | 1.2-1.4x |
| Austin, Nashville, Portland | 1.0-1.2x |
| National Average | 1.0x |
| Rural Midwest | 0.6-0.8x |
| Rural South | 0.7-0.85x |

## Quick Start Prompts

**Budget Reality Check:**
```
We're planning a wedding for 120 guests in [CITY] with a $35k budget.
We love beautiful venues and amazing food. Can you show us what our
budget breakdown should look like and what we'd have to cut?
```

**Priority Conflict Resolution:**
```
My fiancee wants to spend $6k on flowers because it's her passion.
I want $5k on videography. Our total budget is $40k for 110 guests.
If we do both, what gets cut?
```

**Guest Count Impact:**
```
We budgeted $50k for 100 guests, but family pressure is pushing us
toward 180 guests. How much does this actually change our wedding?
```

## Research Sources

- A Practical Wedding (apracticalwedding.com) - Budget frameworks
- The Knot Wedding Budget Breakdown - Industry cost data
- Reddit r/weddingplanning - Real couple budget breakdowns
- WeddingWire - Vendor pricing data
- Zola - Budget tracking patterns

---

Downloaded from [Find Skill.ai](https://findskill.ai)
