---
name: holiday-party-planner
version: 1.0.0
description: Plan holiday celebrations with timelines, menus, decorations, and guest coordination
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This is a prompt-only skill for planning holiday celebrations and parties. No scripts or additional files are needed - simply use SKILL.md directly with any AI assistant.

The skill helps hosts with:
- Week-by-week planning timelines scaled to event size
- Holiday-specific menus with quantity calculations
- Decoration ideas organized by budget tier
- Guest RSVP tracking and dietary management
- Gift exchange organization
- Day-of running schedules

## Directory Structure

```
holiday-party-planner/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - the skill works directly from SKILL.md content.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r holiday-party-planner/ ~/.claude/skills/holiday-party-planner/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Start planning your celebration!

## Compatibility

Tested and optimized for:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)

## Variables

Customize these for your specific event:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{holiday_type}}` | Christmas dinner | The holiday or occasion |
| `{{guest_count}}` | 15 guests | Expected number of attendees |
| `{{event_date}}` | December 24, 2025 | When the event happens |
| `{{venue}}` | home | Location of the celebration |
| `{{budget}}` | $500 | Total event budget |
| `{{dietary_needs}}` | one vegetarian, one gluten-free | Restrictions to accommodate |
| `{{vibe}}` | cozy and traditional | Desired atmosphere |

## Example Usage

After loading the skill, try prompts like:

**Full party planning:**
"I'm hosting Thanksgiving for 18 people. Budget is $400. I need a complete plan including timeline starting 3 weeks out, traditional menu with vegetarian options, decoration ideas, and a day-of schedule."

**Menu planning only:**
"Create a Christmas dinner menu for 12 adults. One guest is gluten-free, one is dairy-free. Budget for food is $250. Include appetizers, main course, sides, and dessert with quantities."

**Timeline only:**
"Give me a week-by-week planning timeline for a New Year's Eve party with 40 guests at my home. We're 6 weeks out."

**Gift exchange organization:**
"Help me set up a White Elephant gift exchange for our office holiday party. 15 participants, $25 limit. I need rules explanation and tips for making it fun."

**Budget planning:**
"Help me create a budget breakdown for a Halloween party for 25 adults. Total budget is $350. We want decorations, food, drinks, and some activity supplies."

## Tips for Best Results

1. **Be specific about guest count**: Exact numbers help with food quantities
2. **Mention all dietary needs upfront**: Include allergies and preferences
3. **State your experience level**: First-time host vs. experienced entertainer
4. **Include your help situation**: Solo hosting or have assistants
5. **Mention must-have traditions**: Things you can't skip
6. **Ask for alternatives**: Request backup plans for common issues

## Supported Holidays

- Christmas (all variations)
- Thanksgiving
- New Year's Eve
- Halloween
- Easter
- Hanukkah
- 4th of July
- Valentine's Day
- Super Bowl/game day parties
- Any custom celebration or themed party

---
Downloaded from [FindSkill.ai](https://findskill.ai)
