---
name: carry-on-packing-optimizer
version: 1.0.0
---

# Carry-On Packing Optimizer - Initialization

Transform your 2-week trip into a carry-on-only adventure with strategic color palettes, compression techniques, quick-dry fabrics, and hand-washing rotation systems.

## What This Skill Does

- Creates personalized packing lists based on trip duration, destination, and activities
- Builds coordinated color palettes where every item pairs with every other item
- Recommends quick-dry fabrics and travel-optimized clothing brands
- Provides compression cube packing strategies and bag loading order
- Calculates outfit mathematics to maximize combinations from minimal pieces
- Generates hand-washing schedules and drying protocols
- Handles special situations: business travel, beach trips, cold weather, family travel

## Package Structure

```
carry-on-packing-optimizer/
├── SKILL.md       # Main skill prompt (copy to AI assistant)
└── INIT.md        # This file - setup instructions
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r carry-on-packing-optimizer/ ~/.claude/skills/carry-on-packing-optimizer/
```

Then reference in your CLAUDE.md or invoke directly.

### ChatGPT / Claude.ai / Gemini

1. Open `SKILL.md` in this package
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into a new conversation with your AI assistant
4. Start describing your trip

### Custom GPT / Claude Project

1. Create a new Custom GPT or Claude Project
2. Paste the content of `SKILL.md` into the system instructions
3. Save and use for all your packing needs

## Usage Examples

### Basic Trip Planning

```
User: I'm going to Portugal for 2 weeks in October. I want to pack
carry-on only and need outfits for city walking, beach days, and
a couple of nice dinners.

AI: [Gathers trip details, suggests color palette, generates
optimized packing list with outfit combinations]
```

### Business + Leisure Combo

```
User: I have a 10-day trip to Tokyo - 3 days of business meetings
and 7 days of sightseeing. Need to look professional but also pack
light for exploring temples and neighborhoods.

AI: [Provides business-casual capsule wardrobe that transitions
between meetings and tourism]
```

### Cold Weather Packing

```
User: Going to Iceland for 2 weeks in February. How do I pack for
cold weather in a carry-on without bringing my whole closet?

AI: [Recommends layering strategy, packable down, merino base
layers, and heat-tech options]
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{trip_duration}}` | 14 days | Length of your trip |
| `{{destination_climate}}` | temperate/warm | Weather conditions expected |
| `{{style_preference}}` | casual with dressy options | Your clothing style |
| `{{color_palette}}` | neutrals (black, navy, white, gray) | Preferred color scheme |
| `{{luggage_type}}` | 40L carry-on backpack | Your bag type and size |

## Key Concepts

### Outfit Mathematics

The skill uses multiplication to show how few items create many outfits:

- 2 bottoms × 5 tops × 2 layers = 20 distinct outfit combinations
- Hand-washing every 2-3 days triples effective wardrobe capacity

### Color Palette Options

1. **Classic Neutral**: Black/navy bottoms + white/cream/gray tops
2. **Warm Earth Tones**: Brown/olive/tan + rust/mustard/sage
3. **Black + Bold**: Black base + vibrant colorful tops

### Compression Strategy

- Fold (don't roll) for compression cubes
- Stack flat to create dense rectangular bricks
- Use underwear/socks as "soft fill" for gaps

## Troubleshooting

**"The AI isn't asking enough questions"**
- Prompt with: "Ask me about my trip before creating a packing list"

**"Suggestions don't fit my style"**
- Specify your style explicitly: "I only wear dark colors" or "I prefer feminine/flowy clothes"

**"I can't hand-wash that often"**
- Mention this upfront; the AI will adjust to pack more items with less washing frequency

## Related Skills

- [Travel Itinerary Planner](/skills/travel-events/travel-itinerary-planner/) - Plan daily activities
- [Budget Planner](/skills/productivity/budget-planner/) - Track travel expenses
- [Major Purchase Advisor](/skills/productivity/major-purchase-advisor/) - Research travel gear

---
Downloaded from [Find Skill.ai](https://findskill.ai)
