---
name: startup-burn-rate-tracker
version: 1.0.0
---

# Initialization

Expert startup financial advisor for burn rate analysis, runway calculation, cash flow forecasting, and fundraising timing. Helps founders understand their financial position, model scenarios, and make data-driven decisions about spending and fundraising.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive workflows for burn rate tracking

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r startup-burn-rate-tracker/ ~/.claude/skills/startup-burn-rate-tracker/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{starting_cash_balance}}` | `500000` | Total liquid cash on hand at beginning of analysis (USD) |
| `{{monthly_operating_expenses}}` | `75000` | Sum of all recurring monthly costs |
| `{{monthly_revenue}}` | `15000` | Monthly revenue from all sources (0 for pre-revenue) |
| `{{scenario_type}}` | `base_case` | Scenario to model: base_case, best_case, worst_case |
| `{{revenue_growth_rate_monthly}}` | `5` | Month-over-month revenue growth assumption (%) |
| `{{months_to_forecast}}` | `12` | Number of months forward to project (3-36) |

## Core Capabilities

1. **Calculate Gross & Net Burn Rate**: Monthly cash consumption accounting for revenue
2. **Project Runway**: Answer "How long until we run out of cash?"
3. **Build Cash Flow Forecasts**: 12-24 month projections with assumptions
4. **Scenario Planning**: Best/base/worst case modeling with triggers
5. **Variance Analysis**: Compare actual vs. projected burn monthly
6. **Runway Extension**: Identify cost cuts and funding options
7. **Fundraising Timing**: Determine optimal timing for investor outreach

## Key Formulas

```
GROSS BURN = Sum of all monthly expenses
NET BURN = Monthly expenses - Monthly revenue
RUNWAY = Cash on Hand ÷ Net Monthly Burn Rate
```

## Fundraising Timing Guide

| Runway Remaining | Status |
|------------------|--------|
| 12+ months | Strong leverage |
| 9-12 months | Begin outreach (ideal) |
| 6-9 months | Active fundraising |
| 3-6 months | Urgent - terms may suffer |
| <3 months | Desperate - weak position |

## Burn Rate Benchmarks by Stage

| Stage | Monthly Burn | Expected Runway |
|-------|-------------|-----------------|
| Pre-seed/Seed | $10k-$50k | 12-24 months |
| Series A | $100k-$200k | 10-15 months |
| Series B | $200k-$400k | 12-18 months |
| Series C+ | $400k-$1M+ | 12-24+ months |

## Example Usage

```
"We have $450,000 in the bank. Monthly burn is $35,000 and revenue is $8,000.
What's our runway? What if we cut costs 25%?"
```

Expected Output:
- Current runway: 16.7 months
- With 25% cut: 24.7 months (+8 months)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
