---
name: solopreneur-daily-standup
version: 1.0.0
---

# Solopreneur Daily Standup - Initialization

Transform into your own accountability partner with structured daily standups, weekly reviews, and monthly retrospectives. AI-guided self-management for solopreneurs, freelancers, and side hustlers.

## What This Skill Does

This skill turns your AI assistant into a personal productivity coach that:

- Runs structured 10-15 minute daily standup rituals
- Guides you through the 3-question format (yesterday, today, blockers)
- Helps you time-block based on your energy levels
- Provides accountability without judgment
- Conducts weekly planning and review sessions
- Facilitates monthly retrospectives for system improvement
- Tracks patterns and calls out consistency issues

## Package Structure

```
solopreneur-daily-standup/
├── SKILL.md          # Main skill prompt (copy to your AI)
└── INIT.md           # This file - setup instructions
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy the skill folder to your Claude skills directory
cp -r solopreneur-daily-standup/ ~/.claude/skills/solopreneur-daily-standup/
```

Then reference in conversations:
```
"Use my solopreneur-daily-standup skill to run my morning standup"
```

### ChatGPT / Custom GPTs

1. Open ChatGPT
2. Create a Custom GPT or start a conversation
3. Copy the content from `SKILL.md` (everything after the frontmatter `---`)
4. Paste as system instructions or conversation starter

### Gemini

1. Open Gemini
2. Start a new conversation
3. Copy the content from `SKILL.md`
4. Paste as your opening message to set context

### Copilot / Other AI Assistants

1. Open `SKILL.md` in a text editor
2. Copy all content after the second `---` line
3. Paste into your AI assistant as the first message

## Variables

Customize these parameters to match your work style:

| Variable | Default | Description |
|----------|---------|-------------|
| `standup_duration` | 15 minutes | How long your daily standup takes |
| `daily_goal_limit` | 3 | Maximum priorities per day (don't exceed) |
| `peak_hours_start` | 9:00 AM | When your cognitive energy is highest |
| `peak_hours_end` | 12:00 PM | End of your peak energy window |
| `deep_work_block_duration` | 50 minutes | Length of focus periods |
| `break_duration` | 10 minutes | Rest between work blocks |
| `weekly_review_day` | Friday 4 PM | When to do weekly planning |
| `accountability_method` | AI + Self | Accountability style |

## Quick Start Guide

### Day 1: First Standup

Start with this prompt:

```
I want to set up a daily standup system. I'm a [solopreneur/freelancer/side hustler]
working on [brief description]. My typical work hours are [X] to [Y], and I feel
most energetic around [time]. Help me run my first standup and explain how this
system works.
```

### Daily Use

Each morning, open your AI and say:

```
Let's do my daily standup. Yesterday I [brief accomplishments]. Today I need to
focus on [priorities]. My biggest obstacle is [blocker if any].
```

### Weekly Review (Friday)

```
Let's do my weekly review. This week I [summary of accomplishments]. I struggled
with [challenges]. Help me plan next week.
```

### Monthly Retrospective (First Sunday)

```
Let's do my monthly retrospective. This month I [major wins and misses]. I noticed
[patterns]. Help me analyze and adjust my system.
```

## Expected Behavior

The AI will:

1. **Ask probing questions** - Not just accept what you say, but challenge vague commitments
2. **Suggest time blocking** - Help match tasks to your energy levels
3. **Track patterns** - Notice when you repeatedly miss certain types of tasks
4. **Be direct** - Call out unrealistic plans and excuses (supportively)
5. **Celebrate wins** - Acknowledge progress and build momentum
6. **Guide system adjustments** - Help you refine your approach over time

## Sample Conversation

**You**: Morning standup. Yesterday I worked on the website but didn't finish. Today I want to finish website, write 3 blog posts, do all my emails, call 5 clients, and plan next month.

**AI**: Hold on—that's 5+ major tasks. You're setting yourself up to fail. What's the ONE thing that must get done today? Let's be realistic: if you finished the website and wrote 1 blog post, that would be a solid day. What's actually achievable in [your available hours]?

## Troubleshooting

### "The AI isn't being direct enough"

Add to your prompt:
```
Be my tough accountability partner. Challenge my excuses and call out unrealistic
plans. I need honest feedback, not validation.
```

### "I keep forgetting to do standups"

- Set a daily phone alarm for standup time
- Tie it to existing habit (right after morning coffee)
- Start with 5 minutes if 15 feels like too much

### "My priorities change mid-day"

Some flexibility is normal. But if this happens constantly:
- Your weekly goals may be unclear
- You may be reactive instead of proactive
- External factors may need boundaries

### "I don't see results after a week"

The habit takes 21-30 days to form. The first week is about building the ritual. Results come from consistency over time.

## Integration Tips

Works best when combined with:

- **Calendar blocking** - Put your time blocks on your calendar
- **Task manager** - Track tasks in Notion, Todoist, or a simple list
- **Timer** - Use Pomodoro/Flowmodoro for deep work blocks
- **Journal** - For deeper reflection beyond the standup

## Success Metrics

Track these to measure improvement:

- Daily completion rate (tasks done vs. planned)
- Standup streak (consecutive days)
- Weekly goal achievement (%)
- Blocker resolution time
- Energy-task alignment accuracy

## Version History

- **1.0.0** - Initial release with daily, weekly, and monthly workflows

---
Downloaded from [Find Skill.ai](https://findskill.ai)
