---
name: referral-program-designer
version: 1.0.0
---

# Referral Program Designer - Initialization

Build referral mechanics, incentive structures, and viral growth loops that turn customers into advocates. Design programs that reduce customer acquisition cost (CAC) by 25-40% while acquiring customers with 16% higher lifetime value.

## What This Skill Does

- Designs one-sided, two-sided, and tiered referral incentive structures
- Calculates optimal reward amounts based on your unit economics (LTV, CAC, margins)
- Creates fraud prevention rules to block self-referrals and abuse
- Recommends attribution models based on your sales cycle length
- Generates A/B testing frameworks for incentive optimization
- Provides industry-specific referral patterns (e-commerce, SaaS, marketplace, local services)

## Structure

```
referral-program-designer/
└── SKILL.md          # Main skill prompt (copy to your AI assistant)
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code
```bash
# Copy skill to Claude Code skills directory
cp -r referral-program-designer/ ~/.claude/skills/referral-program-designer/
```

### ChatGPT / Gemini / Copilot
1. Open `SKILL.md`
2. Copy all content after the frontmatter (below the second `---`)
3. Paste into your AI assistant as a custom instruction or system prompt

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{business_type}}` | `e-commerce` | Your business model (e-commerce, SaaS, marketplace, local service) |
| `{{average_order_value}}` | `$85` | Average purchase amount or contract value |
| `{{customer_lifetime_value}}` | `$425` | Total revenue from average customer over lifetime |
| `{{current_cac}}` | `$32` | Current customer acquisition cost via paid channels |
| `{{target_new_customers}}` | `500` | Target new customers to acquire through referrals |
| `{{sales_cycle_days}}` | `30` | Average days from first contact to conversion |

## Example Usage

**Design a two-sided referral program:**
```
Design a referral program for my e-commerce fashion brand.
- Average order value: $85
- Customer lifetime value: $425
- Current paid CAC: $32
- Target: 500 new customers in Q1

Create the incentive structure with ROI justification, fraud prevention rules,
and 3 A/B test variations.
```

**Optimize an underperforming SaaS referral program:**
```
Our B2B SaaS referral program offers $100 per referral (referrer only)
with a 1.2% conversion rate. Industry benchmark is 8-12%.

Diagnose why it underperforms and redesign with:
- Two-sided vs one-sided analysis
- Tiered rewards for super-advocates
- Attribution model for our 90-day sales cycle
- Fraud prevention for corporate email abuse
```

**Build a viral growth loop for an app:**
```
Design a viral loop for my fitness app targeting Gen Z (18-30).
- 50,000 active users, 8% monthly churn
- Goal: 2x user growth in 6 months (100K new users)

Include gamification, mobile-optimized sharing mechanics,
and fraud prevention for group chat code sharing.
```

## Key Metrics You'll Track

| Metric | Formula | Benchmark |
|--------|---------|-----------|
| Participation Rate | (Enrolled / Total) × 100 | 10-25% |
| Share Rate | (Sharers / Enrolled) × 100 | 20-40% |
| Referral Conversion | (New / Referred) × 100 | 10-30% |
| Viral Coefficient (K) | Invites × Conversion | >0.2 B2B, >0.5 B2C |
| Referral CAC | (Rewards + Costs) / New | 25-40% below paid |

## Related Skills

- **Viral Marketing** - Growth loops and viral mechanics
- **A/B Testing** - Statistical testing of incentive structures
- **Customer Analytics** - Identify high-value advocates
- **Funnel Analysis** - Track referral conversion funnels
- **Email Marketing Automation** - Referral invitation sequences

## Troubleshooting

**Low participation rate (<10%)**
- Program not visible enough - add to post-purchase emails, account dashboard
- Reward not compelling - test higher amounts or different reward types
- Messaging unclear - simplify to "Give X, Get X" format

**Low share rate (<20%)**
- Sharing friction too high - add one-click share buttons
- Pre-written message not compelling - test different copy
- Wrong channels - match sharing options to where customers actually are

**Low conversion rate (<5%)**
- Friend incentive too weak - test higher friend-side rewards
- Landing page unclear - simplify the offer explanation
- Trust gap - add social proof and testimonials

**High fraud rate (>5%)**
- Implement self-referral blocking (email/IP/device matching)
- Add verification period before payout (7-14 days)
- Enable velocity caps (max referrals per customer per month)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
