---
name: pricing-confidence-booster
version: 1.0.0
---

# Pricing Confidence Booster - Initialization

A pricing psychology skill that helps freelancers, consultants, and service providers overcome underpricing anxiety and confidently charge 2-10x more by anchoring to quantifiable value delivered.

## Core Purpose

Transform your pricing mindset from cost-based to value-based. If your solution generates $10X in value, charging $1X is a bargain—this skill helps you communicate that with confidence.

## Structure

```
pricing-confidence-booster/
├── SKILL.md          # Main skill prompt (copy to AI assistant)
└── INIT.md           # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r pricing-confidence-booster/ ~/.claude/skills/pricing-confidence-booster/

# Or add to project-level skills
cp -r pricing-confidence-booster/ .claude/skills/pricing-confidence-booster/
```

### ChatGPT / Claude.ai / Gemini

1. Open `SKILL.md`
2. Copy all content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant as the system prompt or initial context
4. Start with: "I need help with my pricing confidence"

### Claude Projects

1. Create a new project or open existing
2. Add `SKILL.md` to project knowledge
3. The skill will be automatically available in all project conversations

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{base_value_multiplier}}` | `0.2` | Percentage of value to claim (10-30% typical) |
| `{{confidence_level}}` | `beginner` | User's current pricing confidence |
| `{{tier_count}}` | `3` | Number of pricing tiers to design |
| `{{industry_type}}` | `consulting` | Industry for contextual guidance |

## Quick Start Prompts

**Value Discovery:**
```
I'm a [your profession] charging $[current rate]. Help me discover
the real value I deliver to clients and calculate what I should charge.
```

**Imposter Syndrome:**
```
I know I should charge more, but I have imposter syndrome. Help me
build confidence in my pricing with evidence-based reframes.
```

**Objection Handling:**
```
A prospect said my price is too high. Give me a script to respond
that anchors to value rather than defending my cost.
```

**Price Increase:**
```
I want to raise my rates by 50% for new clients. Help me write
the announcement and prepare for pushback.
```

**Tier Design:**
```
Help me design a 3-tier pricing structure for my [service] that
captures different client segments and maximizes revenue.
```

## Key Frameworks Included

### Value Calculation
```
Your Price = 10-30% of Value Delivered
├── Revenue Generated
├── Cost Savings
├── Time Savings × Hourly Rate
├── Risk Mitigation
└── Opportunity Cost
```

### ANCHOR Objection Method
```
A - Acknowledge the concern
N - Navigate to root cause
C - Connect to their pain/cost
H - Highlight ROI
O - Offer proof (case study)
R - Resolve or Release
```

### Confidence Reframes
| Limiting Belief | Reframe |
|-----------------|---------|
| "I'm not experienced enough" | "Results speak louder than years" |
| "Others charge less" | "Others deliver less" |
| "It only took 2 hours" | "It took 10 years to do it in 2 hours" |

## Related Skills

- **Impostor Syndrome Reframer** - Psychology of self-doubt
- **Freelancer Rate Validator** - Market rate benchmarking
- **Salary Negotiation Coach** - Negotiation scripts
- **Negotiation Stance Builder** - Negotiation frameworks
- **Consulting Proposal Generator** - Proposal templates

## Expected Outcomes

After using this skill, you should be able to:

1. **Quantify your value** in dollars saved/generated for clients
2. **Calculate appropriate pricing** based on 10-30% of value delivered
3. **Design tiered pricing** that captures different market segments
4. **Handle objections** without discounting or apologizing
5. **Announce price increases** with confidence
6. **Position yourself** as a premium provider

## Troubleshooting

**"I don't know what value I deliver"**
→ Use the Value Discovery Questions to calculate revenue generated, costs saved, and time saved for clients

**"My industry is different"**
→ The skill includes guidance for designers, consultants, SaaS, and coaches—specify your industry for tailored advice

**"Clients always negotiate"**
→ This is a sign of healthy pricing. Use the objection scripts to hold your value without discounting

**"I'm scared to raise prices"**
→ Start with the Confidence Architecture section; document your wins before changing rates

## Version History

- **1.0.0** - Initial release with value discovery, confidence building, objection handling, and industry-specific guidance

---
Downloaded from [Find Skill.ai](https://findskill.ai)
