---
name: nurture-sequence-generator
version: 1.0.0
---

# Nurture Sequence Generator - Initialization

Create automated email sequences that warm cold leads through educational content, trust-building, and strategic timing to achieve 2-3x higher conversion rates than single cold emails.

## What This Skill Does

This skill transforms you into an expert email marketing strategist who creates nurture sequences that:

- Convert cold leads to warm prospects through value-first content
- Follow the 80/20 rule (80% education, 20% offer)
- Use behavioral triggers for personalized journeys
- Achieve 5-13% reply rates vs 1-3% industry average
- Include 5 proven sequence types for different scenarios

## Package Structure

```
nurture-sequence-generator/
├── SKILL.md          # Main skill prompt (500+ lines)
└── INIT.md           # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r nurture-sequence-generator/ ~/.claude/skills/nurture-sequence-generator/

# Verify installation
ls ~/.claude/skills/nurture-sequence-generator/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_audience_title}}` | `Operations Manager` | Recipient's job title for pain point targeting |
| `{{industry_vertical}}` | `SaaS` | Industry (SaaS, Real Estate, E-commerce, Healthcare) |
| `{{sequence_length}}` | `5` | Number of emails (3-7 recommended) |
| `{{email_cadence_days}}` | `2,4,7,12,21` | Days between emails |
| `{{offer_type}}` | `discovery_call` | CTA type (discovery_call, free_trial, demo, webinar) |
| `{{nurture_stage}}` | `cold` | Lead stage (cold, warm, discovery_call_follow_up) |

## Quick Start Examples

### Example 1: SaaS Trial Conversion

```
Create a 5-email nurture sequence for B2B SaaS product.
Target: IT Operations Directors at mid-size companies
Industry: Cloud Infrastructure
Goal: 30-day free trial signup
Tone: Educational, consultant-like
Cadence: Days 0, 2, 5, 10, 15
```

### Example 2: Agency Cold Outreach

```
Generate a 4-email cold outreach sequence.
Target: E-commerce store owners with 6-figure revenue
Pain: Not optimizing email to existing customers
Goal: Book 30-minute audit call
Cadence: Day 1, 4, 9, 16
```

### Example 3: Real Estate Follow-Up

```
Create a 6-email nurture sequence for real estate.
Target: First-time home buyers who attended open house
Stage: Interested but haven't made offer
Goal: Re-engage without being pushy
Cadence: Days 1, 4, 8, 14, 21, 30
```

## Included Sequence Types

1. **Post-Lead Magnet** - Convert downloads to calls (15-25% conversion)
2. **Post-Cold Email** - Warm unresponsive prospects (5-15% reply rate)
3. **Post-Discovery Call** - Keep momentum post-meeting (30-40% advance)
4. **Win-Back/Re-Engagement** - Reactivate dormant leads (12-18% reactivation)
5. **Event/Webinar Follow-Up** - Convert attendees (5-12% conversion)

## Performance Benchmarks

| Metric | Industry Avg | With Nurture Sequence |
|--------|-------------|----------------------|
| Open Rate | 20-40% | 40-60%+ |
| Reply Rate | 1-3% | 5-13%+ |
| Conversion | 1-5% | 3-10%+ |

## Best Practices Included

- Subject line optimization patterns
- 80/20 rule for educational vs sales content
- Cadence frequency recommendations
- Personalization hierarchy (3 levels)
- CTA progression strategy
- Common objection handling scripts
- Behavioral branching triggers

---
Downloaded from [Find Skill.ai](https://findskill.ai)
