---
name: lead-magnet-ideator
version: 1.0.0
---

# Lead Magnet Ideator - Initialization

Generate high-converting PDF lead magnet ideas that attract qualified leads, not freebie-seekers. Create strategic opt-in offers aligned with your paid products.

## Package Structure

```
lead-magnet-ideator/
├── SKILL.md    # Main skill prompt (500+ lines)
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code (Recommended)

```bash
# Copy to Claude Code skills directory
cp -r lead-magnet-ideator/ ~/.claude/skills/lead-magnet-ideator/

# Or create symlink for easy updates
ln -s /path/to/lead-magnet-ideator ~/.claude/skills/lead-magnet-ideator
```

After installation, reference in conversations with:
```
Use the lead-magnet-ideator skill to help me create lead magnets for my [business type]
```

### ChatGPT / Claude Web / Other AI Assistants

1. Open `SKILL.md` in any text editor
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or at the start of conversation
4. Begin with your request

### Custom GPT / Claude Project

1. Create new Custom GPT or Claude Project
2. Paste SKILL.md content into instructions/system prompt
3. Save and use naturally

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `target_audience` | (empty) | Detailed description of ideal client (role, stage, niche, pain points) |
| `core_pain_point` | (empty) | Single biggest problem the lead magnet should address |
| `main_offer` | (empty) | Your primary paid product/service for funnel alignment |
| `preferred_format` | `checklist` | PDF format: checklist, template, swipe_file, worksheet, mini_case_study, roadmap, calculator |
| `industry_niche` | (empty) | Specific niche (e.g., B2B SaaS, fitness coaching, real estate) |
| `tone_style` | `conversational` | Voice style: professional, bold, empathetic, no-fluff, friendly |

## Quick Start Examples

### Coaching Business

```
Act as a Lead Magnet Ideator. My target audience is [women in their 30s stuck
in unfulfilling corporate jobs]. My main offer is a [12-week career transition
coaching program]. Suggest 7 specific PDF lead magnet ideas, each solving a
clear micro-problem, with title, format, and a 5-bullet outline. Make sure
each idea naturally leads into my paid program.
```

### B2B Agency

```
I run a [B2B paid ads agency] for [bootstrapped SaaS founders]. I want a PDF
lead magnet that attracts buyers, not freebie hunters. Propose 5 ideas using
templates, calculators, or scorecards. For each, explain the quick win, ideal
length, and the CTA that bridges to a strategy call.
```

### Creator / Newsletter

```
I write a newsletter about [solo entrepreneurship and one-person businesses].
My goal is to grow high-quality subscribers who might later buy a [course on
productized services]. Generate 5 high-perceived-value PDF ideas (swipe files,
frameworks, or one-page roadmaps) including suggested titles, short
descriptions, and recommended opt-in copy for my landing page.
```

## Key Capabilities

1. **Pain-Point to PDF Ideas**: Turn audience problems into specific, high-value lead magnet concepts
2. **Format Recommendations**: Choose optimal format (checklist, template, swipe file, etc.) for your niche
3. **Title Optimization**: Craft titles that maximize perceived value and click-through
4. **Content Outlining**: Structure PDFs for quick consumption and action
5. **Funnel Alignment**: Ensure lead magnets attract qualified buyers, not freebie-seekers
6. **Follow-Up Strategy**: Suggest email angles and CTAs to convert downloads to sales
7. **Competitor Differentiation**: Create gap-filling offers based on market analysis

## Supported Workflows

- **Workflow 1**: Pain-Point to Quick-Win PDF
- **Workflow 2**: Competitor Gap Lead Magnet
- **Workflow 3**: Content Upgrade from Existing Assets
- **Workflow 4**: Funnel-Aligned "First Step" Asset

## Best Practices

- Focus on ONE micro-problem per lead magnet
- Keep PDFs short (1-7 pages ideal)
- Use tool-like formats over pure information
- Include clear CTAs that bridge to your paid offer
- Track opt-in rates AND lead quality

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Low opt-in rate | Make title more specific, test different hooks |
| Wrong audience | Narrow focus, align with paid offer topic |
| No conversions | Strengthen bridge between lead magnet and offer |
| Too many ideas | Test 2-3, measure results, pick winner |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
