---
name: ip-assignment-writer
version: 1.0.0
---

# Initialization

Intellectual Property Assignment Writer - Generate legally sound IP assignment agreements for patents, copyrights, trademarks, trade secrets, and software. Covers employee invention assignments, contractor work-for-hire agreements, startup founder IP capitalization, and M&A patent transfers.

## Structure

- `SKILL.md` - Main skill prompt with complete IP assignment document generation capabilities

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r ip-assignment-writer/ ~/.claude/skills/ip-assignment-writer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{assignor_name}}` | `[Assignor Legal Name]` | Full legal name and address of the party transferring IP rights |
| `{{assignee_name}}` | `[Assignee Legal Name]` | Full legal name and address of the party receiving IP rights |
| `{{ip_type}}` | `patent` | Type of IP: patent, copyright, trademark, trade_secret, software, all_types |
| `{{assignment_scope}}` | `exclusive` | Whether assignment is exclusive or non_exclusive |
| `{{territory}}` | `worldwide` | Geographic scope: worldwide, country_specific, or regional |
| `{{consideration_amount}}` | `0` | Monetary or described value exchanged for the assignment |
| `{{jurisdiction}}` | `US` | Governing law jurisdiction for interpretation and enforcement |

## Capabilities

This skill generates the following IP assignment document types:

1. **Employee Invention Assignment** - Secure ownership of inventions created during employment
2. **Contractor Work-for-Hire Agreement** - Transfer ownership of freelance/contract work
3. **Patent Assignment Agreement** - Transfer patent rights in M&A or licensing deals
4. **Copyright Assignment Agreement** - Transfer ownership of creative or software works
5. **Trademark Assignment Agreement** - Transfer brand marks with associated goodwill
6. **Trade Secret Assignment Agreement** - Transfer confidential business information
7. **Software/Source Code Assignment** - Transfer code, algorithms, and technical IP
8. **Founder IP Capitalization Agreement** - Convert founder IP into company equity

## Key Features

- Present assignment language ("hereby assigns") for immediate, effective transfer
- State-specific employee invention protections (CA, IL, MN, WA, NC)
- Copyright Section 203 termination rights disclosure
- Trademark goodwill transfer requirements
- USPTO/EPO recording instructions
- Multi-jurisdiction considerations (US, EU, UK)
- M&A due diligence provisions
- Startup investor-ready documentation

## Example Usage

```
Create an IP assignment agreement for TechCorp Inc. acquiring all patent and
trade secret rights from newly hired software engineer Sarah Chen. Assignment
should cover inventions created during employment using company resources,
worldwide exclusive rights, permanent duration, compensation structured as
$50,000 cash bonus plus stock options. Include prior inventions disclosure,
hobby programming waiver for personal projects created on personal time with
personal equipment, and specify California law governs disputes.
```

## Important Notes

- All generated documents include legal disclaimer
- Documents require review by qualified IP attorneys
- IP laws vary significantly by jurisdiction
- Recording with USPTO/Copyright Office recommended for enforcement
- Work-for-hire doctrine has specific requirements under Copyright Act Section 101

---
Downloaded from [Find Skill.ai](https://findskill.ai)
