---
name: exit-strategy-planner
version: 1.0.0
---

# Exit Strategy Planner - Initialization

Build acquisition or IPO readiness roadmaps for private companies. This skill provides expert frameworks for M&A exits, IPO preparation, dual-track strategies, valuation modeling, and due diligence.

## What This Skill Does

Transforms Claude into an M&A advisor and IPO preparation specialist that helps:

- **Exit Readiness Assessment**: Evaluate financial, operational, legal, and governance readiness across all exit paths
- **M&A Acquisition Planning**: 6-12 month roadmaps for strategic sales, acquihires, and carve-outs
- **IPO Preparation**: 18-24 month execution plans including SEC filing, governance, and SOX compliance
- **Dual-Track Strategy**: Simultaneous M&A and IPO preparation to maximize optionality
- **Valuation Modeling**: DCF, comparable company, and precedent transaction analysis
- **Due Diligence Preparation**: Virtual data room organization and buyer preparation
- **Post-Exit Integration**: Day One readiness and 100-day integration planning

## Package Structure

```
exit-strategy-planner/
├── SKILL.md       # Main skill prompt (copy to AI assistant)
├── INIT.md        # This file - setup instructions
└── index.md       # Website metadata (not needed for usage)
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code (Recommended)

```bash
# Copy skill directory to Claude Code skills folder
cp -r exit-strategy-planner/ ~/.claude/skills/exit-strategy-planner/

# Verify installation
ls ~/.claude/skills/exit-strategy-planner/
```

Then reference in conversations:
```
Use my exit-strategy-planner skill to help me prepare for our Series B exit.
```

### Claude.ai / ChatGPT / Other AI Assistants

1. Open `SKILL.md` in this package
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as:
   - A custom instruction/system prompt
   - The beginning of a new conversation
   - A saved prompt template

## Variables

Customize these parameters when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_exit_type}}` | `dual_track` | Exit path: `m_and_a`, `ipo`, `secondary_buyout`, or `dual_track` |
| `{{months_to_exit_target}}` | `18` | Timeline to target exit (months). Min 12 for M&A, 18 for IPO |
| `{{current_readiness_score}}` | `40` | Baseline readiness 0-100. 0-30=high gaps, 30-60=moderate, 60-100=strong |
| `{{annual_revenue_mmr}}` | `5` | Current annual revenue in millions |
| `{{business_model_type}}` | `saas` | Model: `saas`, `software`, `services`, `ecommerce`, `marketplace`, `hardware` |
| `{{desired_buyer_profile}}` | `strategic` | Target: `strategic`, `pe_firm`, `public_acquirer`, or `founder_sale` |

## Example Usage

**M&A Readiness for SaaS Company:**
```
My SaaS company has $8M ARR with 40% YoY growth. We've been approached by 2
strategic buyers but our financial controls are weak (monthly close takes 3
weeks, no formal audit). Build a 90-day M&A readiness roadmap with the
highest-impact improvements organized by week, team responsibilities, and
risk areas.
```

**IPO Preparation Roadmap:**
```
Our B2B enterprise software company is at $22M ARR growing 35% YoY. Board is
pushing for IPO readiness. I need an 18-month IPO preparation roadmap with
phase gates, resource requirements by role, and quarterly milestones. We have
good financials but weak IT controls and informal governance.
```

**Dual-Track Exit Strategy:**
```
We're a Series B marketplace ($6M ARR, 60% growth) with strategic interest
from 3 buyers and underwriter interest in IPO. Build a 12-month dual-track
strategy with decision gates, valuation scenarios at 5x/7x/10x ARR for M&A
and 12x for IPO.
```

## Key Frameworks Included

- **Exit Readiness Assessment**: 8-area evaluation framework
- **M&A Process**: 6-month transaction timeline
- **IPO Roadmap**: 24-month preparation phases
- **Valuation Methods**: DCF, comparables, precedent transactions
- **Due Diligence**: Virtual data room structure and timeline
- **Integration Planning**: 100-day post-acquisition plan

## Best Practices from Research

- Start exit planning 3-5 years before target date
- 72% of acquisitions preceded by buyer relationships
- Maintain financial discipline with clean books and GAAP compliance
- Use dual-track approach to preserve negotiating leverage
- Customer concentration <15% from single customer preferred
- SaaS valuation benchmarks: 7-10x ARR for 40%+ growth companies

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Low valuation offers | Expand buyer pool, consider earnout structure |
| Due diligence failures | Conduct pre-emptive sell-side due diligence |
| Key employee concerns | Implement retention packages early |
| Customer concentration | Diversify before marketing process |
| IP ownership gaps | Audit all assignments immediately |

## Related Skills

- Business Model Canvas Generator
- Financial Projections Generator
- Pitch Deck Creator
- Competitive Analysis Framework
- Cash Flow Projector

---
Downloaded from [Find Skill.ai](https://findskill.ai)
