---
name: emerging-ai-opportunity-scout
version: 1.0.0
---

# Initialization

The Emerging AI Opportunity Scout skill helps entrepreneurs, product managers, and developers identify, validate, and develop AI-powered business opportunities in three high-growth domains: Vertical AI Agents, Wellness Decision Technology, and Underserved SMB Micro-SaaS markets.

## Structure

- `SKILL.md` - Main skill prompt with frameworks, workflows, and best practices

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r emerging-ai-opportunity-scout/ ~/.claude/skills/emerging-ai-opportunity-scout/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_sector}}` | `all` | Focus area: wellness, legal, healthcare, construction, retail_smb, or all |
| `{{market_maturity}}` | `emerging` | Competition level: blue_ocean (undefined), emerging (growing), saturated |
| `{{technical_complexity}}` | `low_code` | Build approach: no_code, low_code, or deep_tech |
| `{{user_persona}}` | `solo_founder` | Your profile: solo_founder, small_team, or vc_backed |
| `{{data_availability}}` | `proprietary` | Data source: public, proprietary, or user_generated |

## Skill Capabilities

### Primary Functions

1. **Vertical AI Agent Opportunity Identification**
   - Identifies industries with high tribal knowledge and low digitization
   - Maps workflows suitable for AI automation
   - Assesses data moat potential and competitive defensibility

2. **SMB Micro-SaaS Gap Analysis**
   - Finds underserved "boring" niches with high pain points
   - Validates pricing power and unit economics
   - Designs adoption paths for non-technical users

3. **Wellness Technology Validation**
   - Applies Positive AI principles to reduce technostress
   - Designs intervention timing and feedback loops
   - Evaluates privacy and regulatory requirements

### Frameworks Included

- **Tribal Knowledge Extraction Assessment** - For vertical AI opportunities
- **SMB Integration Readiness** - For micro-SaaS validation
- **Wellness Technology Viability** - For health and decision-support tools

### Output Formats

- **Opportunity Brief** - Complete analysis with market thesis, solution, and risks
- **Competitive Landscape** - Incumbent analysis with attack vectors
- **Validation Experiment** - Quick test design with success criteria

## Example Usage

```
"I'm a software developer looking to build a vertical AI agent. Help me identify 3 underserved professional verticals with high tribal knowledge that would benefit from AI automation. For each, outline the specific workflow an agent could automate and the unique data moat I'd need to build."
```

## Key Concepts

- **Vertical AI Agents**: Industry-specific AI that executes entire workflows
- **Tribal Knowledge**: Unwritten expertise held by industry veterans
- **Micro-SaaS**: Focused products solving narrow niche problems
- **The SMB AI Gap**: Performance divide between AI-integrated vs experimenting businesses
- **Ambient Intelligence**: Background AI providing proactive assistance
- **Human-in-the-Loop (HITL)**: AI processing with human verification for critical decisions

## Research Sources

This skill synthesizes insights from:
- Turing: How Vertical AI Agents Are Reshaping Industries
- Global Wellness Institute: AI Initiative Trends 2025
- YCombinator: Vertical AI market potential discussions
- NEA: Tomorrow's Titans - Vertical AI
- ArXiv: Positive AI framework research

---
Downloaded from [Find Skill.ai](https://findskill.ai)
