---
name: debt-equity-financing-evaluator
version: 1.0.0
---

# Debt vs. Equity Financing Evaluator - Initialization

An expert corporate finance skill that helps founders, CFOs, and financial analysts compare debt and equity financing options based on business stage, financial health, risk profile, and strategic goals. Analyzes WACC, dilution impact, debt capacity, and capital structure to recommend optimal funding strategies.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive financing evaluation framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r debt-equity-financing-evaluator/ ~/.claude/skills/debt-equity-financing-evaluator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "# DEBT VS. EQUITY FINANCING EVALUATOR")
3. Paste into your AI assistant's system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{business_stage}}` | `growth` | Company stage: startup, early_growth, growth, or mature |
| `{{target_debt_ratio}}` | `0.35` | Desired percentage of debt in capital structure (0-0.70) |
| `{{annual_ebit}}` | `$5,000,000` | Earnings before interest and taxes |
| `{{cost_of_equity}}` | `0.15` | Required return for equity investors (15% typical for growth) |
| `{{interest_rate}}` | `0.07` | Annual interest rate on debt (7% typical for mid-tier) |
| `{{tax_rate}}` | `0.25` | Corporate income tax rate |

## Capabilities

1. **Business Stage Assessment** - Classify company as startup/early growth/growth/mature with appropriate capital structure recommendations
2. **WACC Calculation** - Compute weighted average cost of capital for different debt/equity scenarios
3. **Debt Capacity Analysis** - Determine maximum sustainable debt load based on interest coverage ratios
4. **Equity Dilution Modeling** - Project founder ownership across multiple funding rounds
5. **Scenario Comparison** - Model all-equity, all-debt, and hybrid financing structures
6. **Tax Shield Valuation** - Calculate present value of interest tax deductions
7. **Recommendation Engine** - Provide specific financing recommendations with rationale

## Key Concepts

- **WACC** - Weighted average cost of capital; lower = better capital structure
- **Interest Coverage Ratio** - EBIT / Interest; minimum 2.5x recommended
- **Debt-to-Equity Ratio** - Financial leverage metric; varies by industry
- **Tax Shield** - Tax benefit from deducting interest payments
- **Dilution** - Reduction in ownership when issuing new equity
- **Venture Debt** - Debt for VC-backed startups (12-18% + warrants)
- **Revenue-Based Financing** - Payments flex with revenue (15-30% effective rate)

## Example Prompts

### Seed-Stage SaaS Founder
```
I'm a 9-month-old B2B SaaS startup with $12k MRR, burning $40k/month with 14 months runway. I have two options: (1) Join an accelerator for $150k check at $3M post-money (10% dilution), or (2) Take a $100k venture debt loan at 14% interest with 2-year repayment starting after 6-month grace. Which is better for my situation?
```

### Growth-Stage E-commerce
```
We have $15M ARR, $3M annual profit, existing $10M debt at 5%. We're considering $20M Series C funding. Our options: (A) All equity at $8M dilution, (B) $12M equity + $8M term loan at 6%, or (C) All debt at 5.5% over 7 years. What's optimal capital structure and WACC impact?
```

### Acquisition Financing
```
We have $50M revenue, $15M EBITDA, and want to acquire a complementary firm for $30M. Financing options: (1) Use $15M cash + $15M bank debt, (2) Use $15M cash + $15M seller financing at 4%, or (3) Raise $20M growth equity + use $10M debt. Which structure minimizes WACC?
```

## Quick Decision Framework

**Choose DEBT when:**
- Stable, predictable cash flow
- Want to minimize dilution
- Can service interest in all scenarios
- Have assets for collateral
- High tax rate (maximizes shield)

**Choose EQUITY when:**
- Unpredictable/negative cash flow
- Need investors' expertise + network
- High business risk
- Raising large relative to size
- Early stage validation needed

**Choose HYBRID when:**
- Some stability but still growing
- Balance dilution vs. burden
- Can support moderate debt service
- Clear path to profitability

---
Downloaded from [Find Skill.ai](https://findskill.ai)
