---
name: customer-activation-email-strategy
version: 1.0.0
---

# Initialization

This skill enables AI assistants to design behavior-triggered customer onboarding email sequences that maximize activation, reduce churn, and convert trial users to paying customers using proven customer success frameworks.

## Structure

- `SKILL.md` - Main skill prompt with behavioral trigger frameworks, segmentation strategies, email templates, and KPI tracking

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r customer-activation-email-strategy/ ~/.claude/skills/customer-activation-email-strategy/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's system prompt or conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{product_name}}` | `Product` | Your product or service name |
| `{{trial_length}}` | `14` | Free trial duration in days |
| `{{activation_milestone}}` | `completed first project` | Key action that indicates successful user activation |
| `{{segment_dimension}}` | `plan_type` | Primary segmentation attribute (plan_type, role, use_case) |
| `{{frequency_cap}}` | `1` | Maximum automated emails per user per day |
| `{{activation_target}}` | `40` | Target activation rate percentage |

## Quick Start

After installation, try these prompts:

**Design a complete sequence:**
```
I'm launching a B2B SaaS project management tool with a 14-day free trial.
Our activation milestone is when a user creates their first project AND
invites at least one team member. Design a complete behavior-triggered
email sequence with conditional branching.
```

**Optimize an existing sequence:**
```
Our current onboarding emails are time-based (Day 1, Day 3, Day 7).
Trial-to-paid conversion is 8%. Help me convert this to behavior-triggered
sequences with proper segmentation.
```

**Create win-back campaign:**
```
We have 500 users whose trials expired in the last 30 days without
converting. Design a win-back email sequence to re-engage them.
```

## Key Capabilities

1. **Behavioral Trigger Design** - Create sequences that respond to user actions, not arbitrary timelines
2. **Segmentation Strategy** - Define paths for different user types, roles, and plan types
3. **Email Copywriting** - Templates for welcome, activation, feature education, and conversion emails
4. **KPI Framework** - Track activation rate, time to value, trial conversion, and email metrics
5. **Conditional Logic** - Design branching flows based on user behavior
6. **Win-Back Campaigns** - Re-engage churned users with targeted offers

## Best Use Cases

- SaaS companies with free trials
- Freemium products driving upgrades
- eCommerce post-purchase activation
- B2B onboarding sequences
- Mobile app user activation
- Subscription business retention

---
Downloaded from [Find Skill.ai](https://findskill.ai)
