---
name: commercial-lease-analyzer
version: 1.0.0
---

# Commercial Lease Analyzer - Initialization

Analyze commercial lease agreements to identify unfavorable terms, calculate financial exposure, compare against market rates, and generate negotiation strategies with ready-to-use counter-proposals.

## Package Structure

```
commercial-lease-analyzer/
├── SKILL.md    # Main skill prompt (comprehensive lease analysis instructions)
└── INIT.md     # This initialization file
```

## Files to Generate

None (prompt-only skill). All functionality is contained within the SKILL.md prompt.

## Post-Installation Steps

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r commercial-lease-analyzer/ ~/.claude/skills/commercial-lease-analyzer/

# Verify installation
ls ~/.claude/skills/commercial-lease-analyzer/
```

### ChatGPT / GPT-4

1. Open `SKILL.md` in a text editor
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into a new ChatGPT conversation or custom instructions
4. Provide your lease document or terms for analysis

### Claude (Web/API)

1. Open `SKILL.md`
2. Copy the full prompt content
3. Paste as system prompt or first message
4. Upload or paste your commercial lease for analysis

### Gemini

1. Open `SKILL.md`
2. Copy the prompt content
3. Paste into Gemini conversation
4. Provide lease details for analysis

### Copilot

1. Open `SKILL.md`
2. Copy the prompt content
3. Paste into Microsoft Copilot
4. Submit your lease terms for review

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{lease_type}}` | `commercial` | Type of lease: commercial, retail, office, warehouse, restaurant, medical, industrial |
| `{{jurisdiction}}` | `US-General` | State code (e.g., CA, TX, NY) for jurisdiction-specific legal analysis |
| `{{risk_threshold}}` | `balanced` | Sensitivity level: aggressive (flag everything), balanced (significant issues), conservative (critical only) |
| `{{negotiate_aggressively}}` | `false` | If true, generates more aggressive counter-proposals |
| `{{tenant_sophistication}}` | `beginner` | User experience level: beginner, intermediate, experienced |
| `{{industry_type}}` | `general-retail` | Business type for industry-specific risk analysis |

## Usage Examples

### Full Lease Review

```
I'm opening a coffee shop and considering a 5-year commercial lease in Austin, Texas
for 1,500 sq ft of retail space.

Terms offered:
- Base rent: $28/sq ft/year
- TI Allowance: $8,000 one-time
- CAM: Pro-rata share (estimated $4,500/year)
- Escalation: 3% annually
- Triple-net (NNN) structure

Here's the lease document [PASTE LEASE TEXT]

Please analyze for red flags, compare to market rates, and give me negotiation scripts.
```

### Clause Analysis

```
Our landlord's lease includes this indemnification clause:

"Tenant shall indemnify, defend, and hold harmless Landlord from any and all claims
arising out of Tenant's use of the premises, including claims arising from Landlord's
negligence."

This is for a 5,000 sq ft office lease in NYC. Can you explain what this means,
why it's problematic, and what I should propose as an alternative?
```

### Market Comparison

```
Lease Details:
- Location: Portland, Oregon (Pearl District)
- Space: 3,000 sq ft Class A office
- Base rent: $28/sq ft/year
- TI allowance: $10,000
- Lease term: 5 years
- Escalation: 2.5% annually
- CAM: $8,000/year (uncapped)

How does this compare to market? Where do I have negotiating leverage?
```

## Key Capabilities

1. **Automated Clause Analysis** - Identify problematic terms across 8+ risk categories
2. **Red Flag Detection** - Severity scoring from critical to informational
3. **Legal Enforceability** - Flag illegal clauses by jurisdiction
4. **Market Comparison** - Compare terms against regional standards
5. **Negotiation Scripts** - Ready-to-use counter-proposals and fallback positions
6. **Risk Quantification** - Calculate total lease cost and financial exposure
7. **Insurance Validation** - Verify requirements against standard coverage

## Covered Risk Categories

### Critical Risks
- Indemnification (blanket, landlord negligence)
- Insurance requirements (beyond standard)
- Default provisions (no cure period)
- Personal guaranty (unlimited, no burn-off)
- Relocation clauses (unilateral)
- Assignment/subletting restrictions

### Financial Risks
- CAM charges (uncapped)
- Rent escalation (above market)
- TI allowance (below market)
- Operating expenses (NNN without caps)
- Percentage rent (unclear calculation)
- Security deposit (excessive)

### Operational Risks
- Use clause restrictions
- Hours of operation mandates
- Signage approvals
- Maintenance responsibilities
- Landlord access rights
- Alteration requirements

## Industry-Specific Analysis

The skill includes specialized considerations for:
- **Retail** - Co-tenancy, kick-out clauses, percentage rent
- **Restaurant** - Grease traps, HVAC, permits, kitchen utilities
- **Office** - After-hours HVAC, parking, janitorial
- **Warehouse** - Clear height, loading, floor load, environmental
- **Medical** - HIPAA, permits, medical waste, ADA

## Market Rate Reference

Includes benchmark data for:
- Commercial rent by major market and property type
- TI allowance standards by property type
- CAM charge standards with cap benchmarks
- Escalation rate norms

## Related Skills

- [Lease Gotcha Scanner](/skills/housing/lease-gotcha-scanner/) - For residential leases
- [Contract Analyzer](/skills/productivity/contract-analyzer/) - General contract review
- [Negotiation Stance Builder](/skills/productivity/negotiation-stance-builder/) - Negotiation frameworks
- [Exit Strategy Planner](/skills/solopreneur/exit-strategy-planner/) - Business exit planning

## Disclaimer

This skill provides educational analysis and does not constitute legal advice. For binding lease agreements, consult with:
- Commercial real estate attorney
- Insurance broker
- Local commercial broker
- Accountant for tax implications

---
Downloaded from [Find Skill.ai](https://findskill.ai)
