---
name: client-service-terms-generator
version: 1.0.0
---

# Initialization

Generate enforceable client service agreements with industry-standard liability caps (12-month fee cap), tiered cancellation policies, and balanced terms for freelancers, consultants, and agencies.

## Structure

- `SKILL.md` - Main skill prompt with complete service agreement template

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r client-service-terms-generator/ ~/.claude/skills/client-service-terms-generator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant as system prompt or custom instruction

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{business_name}}` | `Your Business Name` | Your legal business name |
| `{{service_type}}` | `consulting` | Type of services you provide |
| `{{liability_cap_months}}` | `12` | Number of months for liability cap |
| `{{jurisdiction}}` | `United States - Delaware` | Governing law jurisdiction |
| `{{cancellation_tiers}}` | `4 weeks / 2 weeks / 1 week` | Cancellation policy windows |

## Key Features

### Liability Protection
- Industry-standard 12-month fee cap
- Consequential damages exclusion
- Carve-outs for gross negligence and fraud

### Cancellation Policies
- Strict, balanced, or flexible tiers
- Force majeure provisions
- Rescheduling accommodations

### Essential Sections
- Service scope and change orders
- Payment terms and late fees
- IP ownership options
- Confidentiality obligations
- Dispute resolution

### Industry Customization
- Software/Tech: SLA, escrow, data security
- Creative/Design: Portfolio rights, kill fees
- Consulting: Advice disclaimers
- Marketing: Performance disclaimers
- Healthcare: HIPAA BAA

### Jurisdiction Support
- US (California, Delaware, New York)
- UK (Unfair Contract Terms Act)
- EU (GDPR, consumer rights)
- Australia (ACL requirements)
- Canada (provincial variations)

## Quick Start

1. Tell the AI your business type and jurisdiction
2. Specify liability cap preference (12 months recommended)
3. Choose cancellation policy tier
4. Indicate any special clauses needed
5. Review generated agreement with attorney

## Example Usage

```
Generate service terms for my web design agency "Pixel Perfect Studios"
based in California. I want a 12-month liability cap, balanced
cancellation policy, and strong IP protection for my design assets.
Include force majeure and dispute resolution clauses.
```

---

Downloaded from [Find Skill.ai](https://findskill.ai)
