---
name: channel-partner-recruitment
version: 1.0.0
---

# Channel Partner Recruitment - Initialization

Systematically recruit, onboard, and activate channel partners including resellers, VARs, MSPs, and distributors to scale revenue through indirect sales channels.

## Overview

This skill transforms AI assistants into expert channel sales strategists who help organizations build and scale partner ecosystems. The skill covers the complete partner lifecycle from initial recruitment through ongoing engagement and retention.

## Core Capabilities

1. **Ideal Partner Profile (IPP) Development** - Define partner characteristics for success
2. **Partner Value Proposition (PVP) Crafting** - Create compelling partnership messaging
3. **Targeted Recruitment Outreach** - Generate personalized recruitment content
4. **Partner Selection & Qualification** - Screen and evaluate candidates
5. **First 90-Day Activation Planning** - Structure critical onboarding period
6. **Partner Tier & Incentive Structuring** - Build motivating commission structures
7. **Ongoing Partner Engagement** - Develop retention and growth strategies

## Structure

```
channel-partner-recruitment/
├── SKILL.md          # Main skill prompt (copy to AI assistant)
└── INIT.md           # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r channel-partner-recruitment/ ~/.claude/skills/channel-partner-recruitment/
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{commission_rate_base}}` | `20%` | Base recurring commission rate for reseller partners (15-30% typical) |
| `{{partner_response_time_sla}}` | `2 min welcome, 24 hr call` | Target response time to partner inquiries |
| `{{onboarding_duration_days}}` | `90` | Formal onboarding period length (30-120 days) |
| `{{tier_advancement_threshold}}` | `$50K/$250K/$1M` | Revenue thresholds for Bronze/Silver/Gold/Platinum |
| `{{marketing_dev_fund_percentage}}` | `15%` | Annual MDF as percentage of partner revenue |
| `{{first_deal_target_days}}` | `60` | Days from onboarding to first customer close |

## Usage Examples

### Example 1: Define Ideal Partner Profile

```
I run a mid-market CRM company ($25M ARR) focused on B2B SaaS sales teams.
I want to recruit channel partners to expand into financial services and
healthcare verticals. Create an Ideal Partner Profile (IPP) that includes
firmographics, business model fit, customer segment alignment, GTM strategy
match, technical expertise, cultural fit, and success metrics.
```

### Example 2: Craft Recruitment Messaging

```
I'm recruiting VARs who specialize in healthcare IT implementation. These
partners have $2-10M revenue and serve 50-100 healthcare customers. My
product is a telehealth platform. Create: 1) a Partner Value Proposition,
2) a personalized recruitment email template, 3) a 10-slide pitch deck
outline, and 4) segment-specific messaging.
```

### Example 3: 90-Day Onboarding Plan

```
I just signed two partners: a regional VAR ($5M revenue) and a national
systems integrator ($50M+). Both sell to mid-market manufacturing. Create
a detailed 90-day onboarding plan with weekly activities, success metrics,
deal registration playbook, mutual action plan template, and QBR format.
```

## Key Frameworks Included

- **IPP Framework**: Firmographics, business model, GTM alignment, expertise, culture
- **PVP Template**: Headline + Problem + Solution + Proof + CTA
- **Qualification Scorecard**: Weighted criteria for partner evaluation
- **Tier Matrix**: Bronze/Silver/Gold/Platinum structure with benefits
- **90-Day Onboarding**: 5-phase activation framework
- **QBR Agenda**: Structured quarterly business review template
- **Health Score**: Partner health monitoring and intervention triggers

## Industry Benchmarks

| Metric | Standard |
|--------|----------|
| SaaS Commission | 15-30% recurring |
| Onboarding Period | 30-90 days |
| Partner Manager Ratio | 1:10-20 partners |
| First Deal Target | 60-90 days |
| QBR Frequency | Quarterly |

## Post-Init Verification

After installation, test with:

```
Help me create an Ideal Partner Profile for recruiting managed service
providers to resell our cloud security solution.
```

The AI should respond with discovery questions about your business,
then provide a structured IPP framework customized to your context.

## Related Skills

- Partnership Opportunity Evaluator
- Go-to-Market Strategy Creator
- Cold Email Sequences
- Pitch Deck Creator
- Negotiation Stance Builder

---
Downloaded from [Find Skill.ai](https://findskill.ai)
