---
name: incident-postmortem-generator
version: 1.0.0
---

# Incident Postmortem Generator - Initialization

Generate comprehensive, blameless incident postmortems with structured RCA methodologies, timeline reconstruction, impact quantification, and actionable follow-up items for SRE and DevOps teams.

## Package Structure

```
incident-postmortem-generator/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Installation Steps

### Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r incident-postmortem-generator/ ~/.claude/skills/incident-postmortem-generator/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Start describing your incident for postmortem generation

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `{{incident_severity}}` | `P2` | Priority level (P1/P2/P3/P4) determining postmortem depth and urgency |
| `{{rca_methodology}}` | `5_whys` | RCA approach: 5_whys, fishbone, fault_tree, or hybrid |
| `{{include_financial_impact}}` | `false` | Whether to quantify financial cost of the incident |
| `{{postmortem_template}}` | `standard` | Template complexity: lightweight, standard, comprehensive |
| `{{action_item_tracking}}` | `jira` | Integration: jira, github, linear, notion, asana |
| `{{publication_scope}}` | `engineering_team` | Distribution: engineering_team, all_staff, leadership_only, public |

## Quick Usage Examples

### Basic Database Incident

```
Generate an incident postmortem for:
- Incident: Database connection pool exhaustion
- Duration: 45 minutes
- Affected: ~2,000 active users
- Severity: P1
- Root causes: Recent deployment increased query load; alerting threshold misconfigured
```

### Security Breach

```
Generate security incident postmortem for:
- Incident: Unauthorized API token access to customer data
- Duration: 72 hours undetected, 12 hours remediation
- Attack vector: Leaked token in GitHub public repo
- Data exposure: 15,000 customer records
- Severity: P1
- Include compliance impact (GDPR)
```

### Cascading Infrastructure Failure

```
Generate detailed postmortem for:
- Incident: Cache failure → database overload → site-wide degradation
- Duration: 2.5 hours
- Impact: 100% user base experienced slowdowns
- Root cause chain: Cache memory leak + inadequate monitoring
- Detection: Customer complaints before monitoring alerts
- Severity: P1
- RCA method: Fault tree
```

## Key Features

- **Blameless Analysis Framework**: Focuses on systems and processes, not individuals
- **Multiple RCA Methods**: 5 Whys, Fishbone (Ishikawa), Fault Tree Analysis
- **Structured Templates**: Lightweight (1-page), Standard, Comprehensive
- **Timeline Reconstruction**: Chronological event documentation
- **Impact Quantification**: Technical, business, and financial impact assessment
- **Action Item Generation**: Tracked follow-ups with owners and deadlines
- **Security Incident Support**: Specialized sections for breaches and compliance
- **Integration Ready**: Formats for JIRA, GitHub Issues, Linear

## Severity Guidelines

| Severity | When to Use | Postmortem Depth |
|----------|-------------|------------------|
| P1 (Critical) | Major outage, revenue impact, data breach | Comprehensive + executive summary |
| P2 (High) | Significant degradation, partial outage | Standard template |
| P3 (Medium) | Limited impact, workarounds available | Lightweight |
| P4 (Low) | Minor issues, cosmetic problems | Brief summary |

## Best Practices Reminder

**Do:**
- Conduct within 24-72 hours while memory is fresh
- Focus on systems, not people
- Assign owners to all action items
- Share findings widely

**Don't:**
- Accept "human error" as root cause
- Skip documentation
- Leave action items untracked
- Create blame or punishment culture

---
Downloaded from [Find Skill.ai](https://findskill.ai)
