---
name: soft-reject-drafter
version: 1.0.0
---

# Soft Reject Drafter - Initialization

A communication skill for crafting kind, clear rejection messages after first dates. Helps users provide honest closure without ghosting or creating false hope.

## Structure

```
soft-reject-drafter/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This file
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Init Steps

### Claude Code Installation
```bash
cp -r soft-reject-drafter/ ~/.claude/skills/soft-reject-drafter/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)
1. Open `SKILL.md`
2. Copy all content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `timing_hours_post_date` | `48` | Hours to wait after date before sending (24-72 optimal) |
| `message_tone` | `warm_honest` | Tone style: warm_honest, neutral_firm |
| `rejection_reason_specificity` | `vague` | How specific: vague (best), moderate, detailed |
| `communication_medium` | `text` | Channel: text (1 date), phone_call (2-5 dates) |
| `compliment_ratio` | `0.3` | Proportion of positive acknowledgment (0.2-0.4) |

## Quick Start

After installation, try this prompt:

> I went on a coffee date yesterday with someone I matched with on Hinge. They were nice but I didn't feel any romantic spark. They just texted asking when we can meet again. Help me write a kind rejection.

## Core Capabilities

1. **Draft rejection messages** following proven 3-part structure
2. **Adjust tone** based on date quality and context
3. **Handle follow-ups** when they ask "why" or push back
4. **Navigate special cases** like mutual friends or multiple dates
5. **Manage sender emotions** like guilt or anxiety

## Message Structure

Every rejection follows this format:
1. **Brief acknowledgment** (1 sentence of gratitude)
2. **Clear rejection** (1-2 sentences using "I" statements)
3. **Kind closure** (1 sentence wishing them well)

## Key Principles

- Honesty over avoidance (ghosting hurts more)
- Brevity over explanation (2-3 sentences total)
- "I" statements over criticism
- Closure over false hope

## Research Sources

- Reddit r/hingeapp, r/datingoverthirty, r/dating_advice
- 10+ community discussions with 400+ upvoted recommendations
- Focus on receiver preferences and tested templates

---
Downloaded from [Find Skill.ai](https://findskill.ai)
