---
name: social-battery-preserver
version: 1.0.0
---

# Social Battery Preserver - Initialization

Generate graceful exit scripts for leaving parties, dinners, and social events early without damaging relationships or appearing rude.

## What This Skill Does

The Social Battery Preserver helps introverts, neurodivergent individuals, and anyone managing social energy limits leave social events gracefully. It provides:

- **Context-appropriate exit scripts** for work, family, friend, and dating situations
- **Pushback handling** when hosts resist your departure
- **Body language guidance** to support your verbal exit
- **Cultural variations** (Irish goodbye, Midwestern farewell, professional protocols)
- **Post-event follow-up templates** to maintain relationships
- **Neurodivergent adaptations** for ADHD, autism, and anxiety

## Structure

```
social-battery-preserver/
├── SKILL.md    # Main skill prompt (copy this to your AI assistant)
└── INIT.md     # This file - initialization instructions
```

## Files to Generate

None (prompt-only skill)

## Installation

### Claude Code

```bash
# Copy skill folder to Claude Code skills directory
cp -r social-battery-preserver/ ~/.claude/skills/social-battery-preserver/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message

## Usage

### Quick Start

After installing, simply describe your situation:

```
I'm at my friend's birthday party, been here 2 hours, and my social
battery is at 30%. I need to leave in the next 15 minutes without
offending the birthday person. Generate an exit script.
```

### Full Context (Better Results)

For optimal exit scripts, provide:

1. **Event type**: work happy hour, friend's party, family dinner, etc.
2. **Current energy level**: 1-10 scale
3. **Time context**: How long you've been there, when event ends
4. **Relationship stakes**: How important is this relationship
5. **Exit urgency**: Immediately, 10 minutes, 30 minutes

### Example Prompts

**Work Event**:
"I'm at a mandatory work happy hour and need to leave. My boss is here. Generate a professional exit that won't hurt my reputation."

**Family Gathering**:
"I'm at my in-laws' house for Sunday dinner. It's been 3 hours and I'm overwhelmed. Help me leave without causing drama."

**Friend's Party**:
"My social battery is dead. I'm at a house party with 20 people and can't find a good moment to leave. What do I say?"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{event_type}}` | `friend_gathering` | Type of social event |
| `{{relationship_closeness}}` | `friend` | How close you are to the host |
| `{{energy_capacity}}` | `50` | Current social energy (1-100%) |
| `{{stimulation_level}}` | `moderate` | Environmental intensity |
| `{{pre_announced}}` | `false` | Whether you announced departure time in advance |
| `{{recovery_time_needed}}` | `48` | Hours needed to recharge after event |

## Expected Output Format

When you request an exit script, you'll receive:

1. **Primary Exit Script** - Word-for-word what to say
2. **Backup Script** - If the host pushes back
3. **Body Language Notes** - Physical actions while speaking
4. **Timing Recommendation** - When to deliver the exit
5. **Post-Exit Follow-Up** - Optional message to send afterward

## Quick Reference

### Universal Exit Phrases

- "I'm heading out, but thanks so much for having me!"
- "This was great—I'm going to take off now."
- "I need to get going, but let's catch up again soon."

### Energy-Honest Exits

- "I'm at my limit, so I'm going to head out."
- "I need to recharge, but I really enjoyed this."
- "My social battery's tapped—thanks for understanding."

### Time-Based Exits

- "I've got an early morning, so I'm calling it."
- "I need to head out before it gets too late."

## Key Principles

1. **State, don't ask** - "I'm heading out" not "Is it okay if I leave?"
2. **Maximum 2 sentences** - More explanation invites more questions
3. **Thank the host** - Always express gratitude
4. **Exit within 3-5 minutes** - Once you say you're leaving, go
5. **Don't apologize repeatedly** - One "thanks" replaces multiple "sorrys"

## Troubleshooting

**Script feels too formal?**
→ Ask for a more casual version based on your specific relationship

**Host keeps pushing back?**
→ Request escalating pushback responses (Level 1, 2, 3)

**Leaving a very small gathering?**
→ Specify the group size for more nuanced advice

**Need to leave immediately (sensory overload)?**
→ Ask for an emergency exit script with minimal explanation

---

Downloaded from [Find Skill.ai](https://findskill.ai)
