---
name: situation-ship-ender
version: 1.0.0
---

# Situation-Ship Ender - Initialization

A communication framework for ending ambiguous romantic relationships with confidence. Helps users craft personalized scripts for the DTR (Define The Relationship) conversation that requests commitment clarity without sounding desperate or issuing ultimatums.

## What This Skill Does

- Crafts confident conversation scripts for relationship clarity discussions
- Provides deflection response strategies for avoidant partners
- Guides users through the 5-phase DTR conversation framework
- Adjusts tone based on relationship duration and partner communication style
- Helps users distinguish between healthy boundaries and ultimatums
- Supports emotional regulation before, during, and after the conversation

## Structure

```
situation-ship-ender/
├── SKILL.md      # Main skill prompt (500+ lines)
└── INIT.md       # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to Claude Code skills directory
cp -r situation-ship-ender/ ~/.claude/skills/situation-ship-ender/

# Add to your CLAUDE.md if desired
echo "- situation-ship-ender: Use for relationship clarity conversations" >> ~/.claude/CLAUDE.md
```

### For ChatGPT / Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (everything after the second `---`)
3. Paste into a new conversation or custom instructions
4. Begin by describing your situation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `relationship_duration_weeks` | `8` | How long you've been in the situation-ship |
| `clarity_level_desired` | `exclusive_commitment` | What you want: exclusive_dating, defined_relationship, clear_future_planning, marriage_timeline |
| `conversation_style` | `compassionate_firm` | Tone: gentle_vulnerable, direct_assertive, diplomatic, compassionate_firm |
| `partner_avoidant_level` | `moderate` | Partner's avoidance: low_avoidant, moderate, highly_avoidant |
| `walkaway_threshold_met` | `false` | Whether you've decided to leave if no commitment |
| `communication_medium` | `in_person` | How you'll have the conversation: in_person, video_call, phone |

## Quick Start Example

```
"I've been seeing someone for 3 months. We act like a couple - regular
sleepovers, texting all day, met each other's friends - but we've never
had 'the talk' about what we are. I'm scared bringing it up will scare
them away, but I'm exhausted from the uncertainty. Help me write a script
for the conversation."
```

## Key Concepts

- **Situation-Ship**: Undefined romantic relationship with relationship behaviors but no official commitment
- **DTR**: Define The Relationship conversation
- **RTR**: Recognize The Relationship (acknowledging what exists before defining wants)
- **Boundary vs Ultimatum**: "I can't continue this way" (boundary) vs "You must do X" (ultimatum)
- **Avoidant Attachment**: Pattern of emotional distancing to maintain independence

## The 5-Phase Framework

1. **Pre-Conversation Preparation** - Identify needs, write talking points, anticipate responses
2. **Conversation Initiation** - Non-threatening opening that suggests the topic
3. **Core Conversation Script** - The main discussion using I-statements and boundaries
4. **Handling Deflection** - Ready responses for avoidance tactics
5. **Post-Conversation Decision** - Process outcome and take appropriate action

## Related Skills

- Relationship Boundary Setter - General boundary communication
- Assertive Communication Coach - Confidence without aggression
- Emotional Regulation Coach - DBT/CBT techniques for managing emotions
- Cognitive Reframing Guide - Transforming negative thought patterns

---
Downloaded from [Find Skill.ai](https://findskill.ai)
