---
name: relationship-conflict-coach
version: 1.0.0
---

# Relationship Conflict Resolution Coach - Initialization

AI-powered coaching for de-escalating relationship conflicts using evidence-based therapeutic frameworks (CBT, DBT, Gottman Method) with communication pattern analysis and empathy-driven prompting.

## Structure

```
relationship-conflict-coach/
├── SKILL.md      # Main skill prompt (comprehensive coaching system)
├── INIT.md       # This initialization file
└── index.md      # Hugo site metadata
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r relationship-conflict-coach/ ~/.claude/skills/relationship-conflict-coach/
```

### ChatGPT / Custom GPT
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT custom instructions or GPT builder

### Gemini
1. Open `SKILL.md`
2. Copy the skill content
3. Paste as system prompt or conversation starter

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant's system prompt or initial message

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{conflict_type}}` | `romantic` | Type of relationship conflict (romantic, family, friendship, roommate, extended_family) |
| `{{communication_style}}` | `avoidant` | User's typical pattern (avoidant, aggressive, passive_aggressive, direct) |
| `{{emotional_intensity}}` | `frustrated` | Current emotional state (calm, frustrated, angry, hurt, overwhelmed) |
| `{{coaching_depth}}` | `standard` | Level of detail (quick_script, standard, deep_analysis) |
| `{{therapeutic_approach}}` | `cbt` | Framework to apply (cbt, dbt, solution_focused, gottman) |
| `{{cultural_context}}` | `western_direct` | Cultural context (western_direct, collectivist, hierarchical, peer_equal) |

## Example Usage

**Basic conflict analysis:**
```
I had a fight with my partner about household chores. I made a critical comment, they got defensive, and we didn't talk for hours. Help me understand what went wrong.
```

**With variables:**
```
[conflict_type: family, communication_style: avoidant, emotional_intensity: hurt]

My mom criticized my parenting decisions and I snapped at her. Now she's giving me the silent treatment. How do I repair this?
```

**Role-play practice:**
```
I need to talk to my roommate about cleanliness issues. Can we practice the conversation? They tend to get defensive when I bring things up.
```

## Core Capabilities

1. **Conflict Pattern Analysis** - Identifies recurring dynamics (attack-defend, pursue-withdraw)
2. **Communication Assessment** - Detects avoidant, aggressive, or passive-aggressive patterns
3. **Gottman Four Horsemen** - Spots criticism, contempt, defensiveness, stonewalling
4. **CBT Reframing** - Challenges automatic thoughts driving conflict
5. **"I" Statement Transformer** - Converts accusations to assertive requests
6. **Role-Play Practice** - Simulates difficult conversations for rehearsal
7. **De-escalation Scripts** - Ready-to-use phrases for heated moments
8. **Post-Conflict Debrief** - Analyzes what worked and identifies growth areas

## When to Use This Skill

- Recurring arguments with partner about same topics
- Family conflicts (especially with parents/in-laws)
- Roommate/housemate tension
- Friendship conflicts
- Preparing for difficult conversations
- Processing conflicts after they happen
- Learning healthier communication patterns

## Safety Note

This skill includes safety protocols for detecting:
- Physical safety concerns
- Emotional abuse patterns
- Power imbalances
- Situations requiring professional support

If these are detected, the skill will recommend appropriate resources rather than communication strategies.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
