---
name: pet-custody-mediator
version: 1.0.0
---

# Pet Custody Mediator - Initialization

Navigate sharing a dog after breakup with mediation frameworks, custody schedules, expense-splitting models, and conflict resolution protocols for amicable co-parenting.

## What This Skill Does

Helps separated or divorced couples navigate the emotionally complex process of determining dog ownership and establishing shared care arrangements. Unlike child custody (which involves legal guardianship and parental rights), pet custody mediation operates within a unique legal and emotional landscape where pets are typically classified as property, but the emotional bonds and caregiving relationships are deeply significant to both parties.

### Core Capabilities

1. **Ownership Determination Assessment** - Guide parties through legal and factual criteria to establish primary ownership vs. shared care rights
2. **Feasibility Analysis** - Evaluate whether both parties can realistically commit to ongoing shared arrangements
3. **Mediation Protocol Facilitation** - Structure neutral conversations to identify underlying needs and viable compromises
4. **Shared Care Agreement Design** - Create detailed schedules, expense splits, and responsibility frameworks
5. **Dog Welfare Optimization** - Ensure transitions, routines, and care standards prioritize the dog's psychological and physical health
6. **Conflict Resolution** - Provide dispute resolution mechanisms when disagreements arise during ongoing co-parenting
7. **Documentation & Legal Formalization** - Translate agreed-upon arrangements into enforceable, written agreements

## Structure

```
pet-custody-mediator/
├── SKILL.md    # Main skill prompt (copy to your AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation Instructions

### Claude Code

```bash
# Copy the skill to your Claude Code skills directory
cp -r pet-custody-mediator/ ~/.claude/skills/pet-custody-mediator/
```

Then reference the skill in your CLAUDE.md or conversation:
```
Use the pet-custody-mediator skill to help me navigate sharing my dog with my ex.
```

### ChatGPT / Custom GPT

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter block
3. Paste into ChatGPT's "Custom Instructions" or create a new Custom GPT with this as the system prompt

### Claude.ai (Web/App)

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter block
3. Start a new conversation and paste as the opening message, or add to a Project's instructions

### Gemini

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter block
3. Paste into Gemini and ask it to act as this mediator

### GitHub Copilot Chat

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter block
3. In VS Code Copilot Chat, paste as context or add to workspace instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `custody_schedule_type` | `weekly_alternating` | Primary custody model (weekly_alternating, bi_weekly, monthly_rotation, flexible_arrangement, primary_with_visitation) |
| `handoff_location` | `Neutral public space (park)` | Where dog transitions between parties |
| `expense_split_percentage` | `50/50` | How veterinary and care costs are divided |
| `communication_channel` | `Email for non-urgent, text for urgent` | Primary method for sharing updates |
| `veterinary_decision_authority` | `Party with current custody has authority unless life-threatening` | Who makes routine vs emergency medical decisions |
| `dispute_escalation_pathway` | `Direct discussion -> Mediator review -> Arbitration` | Steps for addressing disagreements |

## Example Usage

**Initial Consultation:**
```
My ex and I just broke up after 3 years together. We adopted our dog Max 2 years ago and we both love him equally. We want to figure out if we can share custody without going to court, but I don't even know where to start. Help me understand if this is even feasible.
```

**Creating an Agreement:**
```
We agreed in mediation that we want to do weekly custody swaps (I have Mon-Thurs, she has Thurs evening-Sun). Now we need to write out the actual agreement including vet costs since he needs ongoing allergy medication. What should we include?
```

**Handling Disputes:**
```
We've had 50/50 custody for 6 months and it mostly works, but my ex just told me he's moving 2 hours away for a new job. Our current weekly swap schedule won't work anymore. How do we modify this agreement fairly?
```

## Best Practices

- **Prioritize dog's wellbeing** over adult emotional preferences
- **Start with feasibility assessment** - not all breakups lead to successful shared custody
- **Use written communication** (email) for logistics to reduce misunderstandings
- **Keep communication about the dog only** - avoid using pet as bridge to maintain relationship
- **Build in review periods** - agreements that work at 6 months may not work at 2 years
- **Document everything** - vet records, expenses, microchip registration should reflect both parties
- **Involve veterinarian** - brief vet so both parties are recognized as authorized caregivers
- **Create clear handoff protocols** - specify location, time window, and communication at handoff

## Related Skills

- Breakup Logistics Manager - Broader breakup logistics including asset division
- Difficult Conversation Opener - Start hard conversations without triggering defensiveness
- Assertive Communication Coach - Communicate needs clearly during mediation
- Emotional Regulation Coach - Manage intense emotions during custody discussions
- Stress Management - Cope with breakup stress and co-parenting anxiety

---
Downloaded from [Find Skill.ai](https://findskill.ai)
