---
name: no-practice-coach
version: 1.0.0
---

# Initialization

An interactive assertiveness coach that helps users overcome the psychological and practical challenges of saying "no" through role-play simulations, personalized scripts, and guilt management coaching.

## Structure

- `SKILL.md` - Main skill prompt (comprehensive assertiveness coaching system)

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r no-practice-coach/ ~/.claude/skills/no-practice-coach/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Core Capabilities

| Capability | Description |
|------------|-------------|
| Practice Gym | Interactive role-play with adjustable pressure levels (1-5) |
| Script Architect | Generate refusal scripts in multiple tones |
| Tone Analysis | Evaluate responses for clarity, firmness, over-explanation |
| Guilt Management | CBT-based cognitive reframing for post-refusal guilt |
| Scope Creep Defense | Professional templates for workplace boundary setting |
| Framework Teaching | Positive No, Essentialist No, Broken Record techniques |

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `relationship_type` | `colleague` | Who you need to say no to (boss, friend, parent, colleague, stranger) |
| `pressure_level` | `medium` | How hard AI pushes back (low, medium, high, toxic) |
| `refusal_style` | `firm` | Desired tone (polite, firm, humorous, hard-no) |
| `medium` | `in-person` | Communication channel (email, slack, in-person, phone) |
| `emotional_state` | `anxious` | Current emotional context (guilty, angry, exhausted, anxious) |

## Key Frameworks Included

### The Positive No (William Ury)
- Yes! (to your values)
- No (to the request)
- Yes? (to the relationship)

### The Essentialist No (Greg McKeown)
- Every "yes" is a "no" to something else
- Frame as trade-off, not rejection

### The Broken Record Technique
- Repeat refusal calmly without elaboration
- Don't add new arguments

### JADE Avoidance
- Don't Justify, Argue, Defend, or Explain
- Over-explaining weakens position

## Scenario Categories

- **Workplace**: Weekend work, scope creep, covering shifts, volunteering
- **Family**: Holiday obligations, money requests, unsolicited advice
- **Friends**: Lending money, social events, favor escalation
- **Strangers**: Sales pressure, aggressive asks
- **Partners**: Unwanted plans, purchases, family visits

## Usage Examples

### Role-Play Practice
```
"I need to practice saying no to my boss who keeps asking me to work weekends.
Set pressure level to 4. Act as my boss and try to guilt-trip me when I refuse."
```

### Script Generation
```
"Write 3 scripts for declining my mother-in-law's request to host Thanksgiving.
I want a gentle version, a firm version, and a Positive No version."
```

### Guilt Management
```
"I just told my friend I can't help her move this weekend and now I feel
terrible. She sounded so disappointed. Help me not cave and call her back."
```

### Tone Analysis
```
"Evaluate this response: 'I'm so sorry, I really wish I could but I just have
so much going on right now, maybe another time?' Is this strong enough?"
```

## Research Foundation

- William Ury's "The Power of a Positive No"
- Greg McKeown's "Essentialism"
- Academic research on explicit vs. ambiguous rejection (NCBI)
- Linguistic analysis of refusal strategies
- CBT techniques for guilt management
- Assertiveness training methodologies

---

Downloaded from [Find Skill.ai](https://findskill.ai)
