---
name: no-gift-christmas-announcement
version: 1.0.0
---

# Initialization

This skill helps you craft thoughtful messages to announce a no-gift Christmas to family members, handle objections gracefully, and suggest meaningful alternatives that preserve relationships while honoring your boundaries.

## Structure

- `SKILL.md` - Main skill prompt with message templates, objection handlers, and communication strategies

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r no-gift-christmas-announcement/ ~/.claude/skills/no-gift-christmas-announcement/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant as the system prompt or initial context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{family_structure}}` | `extended family with parents, siblings, and in-laws` | Who needs to receive the announcement |
| `{{main_reason}}` | `focus on quality time together instead of material gifts` | Primary motivation for going gift-free |
| `{{comfort_level}}` | `direct but gentle` | Communication style (assertive, warm, formal, casual) |
| `{{gift_exception}}` | `kids under 12 can still receive gifts` | Any exceptions to the no-gift policy |
| `{{alternative_preference}}` | `experience activities, charitable donations, or consumable treats` | What to suggest instead of physical gifts |

## What This Skill Provides

### Message Templates (5 types)
1. **Direct and Warm** - For close families comfortable with straightforward communication
2. **Group Text/Email** - Efficient announcements for extended family
3. **Boundary Re-Establishment** - When previous requests were ignored
4. **Gentle Introduction** - For gift-loving relatives who need extra care
5. **Financial Reasons** - When money is the driver but you don't want "solutions"

### Objection Handlers
Pre-written responses for common pushback:
- "But I already bought your gift!"
- "It won't feel like Christmas without gifts!"
- "But I love giving gifts!"
- "You're being ungrateful/selfish"
- "My kids will be disappointed"
- "This is just temporary, right?"

### Boundary Enforcement
Scripts for when gifts arrive anyway:
- Polite redirection
- Refuse at the door
- Return to sender
- Grace period response

### Alternative Suggestions
- Experience-based activities (game nights, cooking together, etc.)
- Charitable giving options
- Modified gift exchanges (Secret Santa, spending limits)
- Sentimental alternatives (recipe exchange, memory sharing)

## Example Usage

**User prompt:**
"My husband and I want to tell both our families that we're not doing gifts this Christmas. I'm nervous about his mom's reaction - she loves giving elaborate gifts and might feel rejected. We want to propose a family game night instead. Can you help me write a message that's warm but firm, acknowledges her love of giving, and makes the game night sound appealing?"

**Expected response:**
A customized message using Template 4 (Gentle Introduction for Gift-Loving Relatives), with:
- Acknowledgment of mother-in-law's gift-giving as an expression of love
- Clear statement of the no-gift boundary
- Enthusiastic framing of game night alternative
- Prepared responses for likely objections

## Timing Guidance

The skill includes timing recommendations:
- **Ideal:** Before Thanksgiving (October-November)
- **Acceptable:** Early December
- **Problematic:** Mid-December or later

---
Downloaded from [Find Skill.ai](https://findskill.ai)
