---
name: love-bombing-detector
version: 1.0.0
---

# Love Bombing Detector - Initialization Manifest

An AI skill that analyzes dating conversations and early relationship patterns to identify manipulative love bombing tactics versus genuine romantic interest using psychology-backed assessment frameworks.

## Overview

Love Bombing Detector helps users recognize manipulation patterns in early dating by analyzing text conversations for red flags, assessing relationship timeline progression, and providing actionable boundary-setting recommendations.

**Key Capabilities:**
- Text message batch analysis for pattern detection
- Red flag identification with specific examples
- Timeline assessment against healthy relationship norms
- Consistency tracking for push-pull dynamics
- Attachment style insights
- Personalized response scripts and exit strategies

## Package Structure

```
love-bombing-detector/
├── SKILL.md      # Main skill prompt (500+ lines)
└── INIT.md       # This initialization manifest
```

## Files to Generate

None - this is a prompt-only skill. All functionality is contained in `SKILL.md`.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r love-bombing-detector/ ~/.claude/skills/love-bombing-detector/

# Or symlink if you prefer
ln -s $(pwd)/love-bombing-detector ~/.claude/skills/love-bombing-detector
```

### For ChatGPT / Custom GPT Users

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT or use as Custom GPT instructions

### For Gemini Users

1. Open `SKILL.md`
2. Copy the full skill content
3. Use as initial context in a new conversation

### For Copilot Users

1. Open `SKILL.md`
2. Copy skill content
3. Paste into Copilot chat as context

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `{{relationship_stage_weeks}}` | `2` | Number of weeks you've been talking/dating |
| `{{message_volume_threshold}}` | `20+ daily` | Message frequency that triggers concern |
| `{{intimacy_pace_level}}` | `moderate` | Your preferred pace (slow/moderate/fast) |
| `{{red_flag_sensitivity}}` | `medium` | Concern threshold (low/medium/high) |
| `{{attachment_awareness}}` | `true` | Include attachment style analysis |
| `{{action_recommendation_type}}` | `communication_strategy` | Guidance type (communication_strategy/boundary_setting/exit_strategy) |

## Usage Examples

### Example 1: New Match Analysis (Week 1)

```
I matched with someone on Hinge 3 days ago. He keeps saying I'm "exactly
what he's been looking for" and "perfect." He asked to meet this weekend
before we've video chatted. Here's our conversation:

[Paste 15-20 messages]

Use medium sensitivity. Is this genuine excitement or love bombing?
```

### Example 2: Pattern Over Time (Weeks 2-4)

```
We've been dating 3 weeks. At first he texted constantly, called me
"beautiful" 5+ times per conversation, talked about moving in together.
Last week he went cold - hours to respond, canceled plans. When I asked
what's wrong, he sent a long "I care about you so much" message and now
he's back to constant texting.

Is this the love bombing cycle? What should I do?
```

### Example 3: Comparative Assessment

```
I'm dating two people and want to evaluate which feels healthier:

Person A: Texts throughout day, asks about my work/family/interests,
steady communication.

Person B: Fewer but much longer/intense messages, lots of compliments
about how "perfect" I am, talks about future a lot.

Analyze both communication styles and what each suggests.
```

## Red Flag Categories

The skill analyzes four categories:

1. **Communication Patterns** - Compliment frequency, pet names, message volume, depth mismatch
2. **Timeline Violations** - Premature "I love you," future faking, exclusivity pressure
3. **Boundary Issues** - Contact violations, information pushing, emotional boundary violations
4. **Consistency Problems** - Hot-cold cycling, word-action mismatch, generic engagement

## Scoring System

- **0-15 points**: Low risk - Normal dating enthusiasm
- **16-35 points**: Moderate risk - Monitor closely, set boundaries
- **36-55 points**: High risk - Significant concern, implement strong boundaries
- **56+ points**: Very high risk - Multiple manipulation indicators, recommend distance

## Psychology Framework

Built on:
- Attachment theory (Bowlby, Ainsworth)
- Narcissistic abuse cycle research
- Intermittent reinforcement psychology
- Healthy relationship timeline norms

## Ethical Notes

- Assessment tool, not professional therapy replacement
- Encourages professional support for abuse survivors
- Avoids pathologizing all dating enthusiasm
- Does not diagnose personality disorders
- Emphasizes constellation of patterns, not single indicators

## Related Skills

- First Date Vibe Check - Early date assessment
- Situation-ship Ender - Unclear relationship decisions
- Emotional Regulation Coach - Processing reactions
- Relationship Boundary Setter - Establishing limits
- Assertive Communication Coach - Direct communication scripts
- Cognitive Reframing Guide - Processing experiences

---
Downloaded from [Find Skill.ai](https://findskill.ai)
