---
name: long-distance-activity-picker
version: 1.0.0
---

# Long Distance Activity Picker - Initialization

An AI skill that helps long-distance couples, friends, and family discover creative, engaging activities for FaceTime, Zoom, Discord, and other video platforms beyond just talking.

## What This Skill Does

- **Activity Recommendation Engine** - Suggests activities based on available time, energy level, and relationship type
- **Game Suggestions & Setup** - Recommends browser games, co-op video games, and question-based games with setup instructions
- **Conversation Frameworks** - Provides structured conversation starters, deep questions, and ice-breaker games
- **Tool/App Matchmaking** - Recommends apps like Teleparty, Discord, Paired for different activity types
- **Ritual Builder** - Helps establish sustainable weekly connection routines
- **Time Zone Accommodation** - Adjusts recommendations based on time zone differences

## Structure

```
long-distance-activity-picker/
├── SKILL.md     # Main skill prompt (copy to AI assistant)
├── INIT.md      # This file - setup instructions
└── index.md     # Website page (not needed for local use)
```

## Files to Generate

None - This is a prompt-only skill. Simply copy the contents of `SKILL.md` into your AI assistant.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill folder to Claude skills directory
cp -r long-distance-activity-picker/ ~/.claude/skills/long-distance-activity-picker/
```

Then reference in your Claude configuration or paste SKILL.md contents into a custom instruction.

### ChatGPT

1. Open ChatGPT
2. Go to Settings → Personalization → Custom Instructions
3. In "How would you like ChatGPT to respond?", paste the contents of `SKILL.md` after the frontmatter (everything after the `---`)

### Gemini / Other AI Assistants

1. Open `SKILL.md` in a text editor
2. Copy everything after the frontmatter section (after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

### Project-Based Installation

Add to your project's AI configuration:

```bash
# Create skills directory in your project
mkdir -p .ai/skills

# Copy skill
cp SKILL.md .ai/skills/long-distance-activity-picker.md
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{available_time_minutes}}` | `60` | Duration of call (5, 15, 30, 60, 90, 120+) |
| `{{energy_level}}` | `medium` | Current energy: low, medium, high |
| `{{preferred_activity_type}}` | `varied` | gaming, conversation, creative, passive, sensory, surprise_me |
| `{{novelty_factor}}` | `moderate` | low (comfort), moderate (mix), high (always new) |
| `{{time_zone_difference_hours}}` | `0` | Hours apart (0-3 easy, 4-8 moderate, 9+ challenging) |
| `{{relationship_stage}}` | `dating` | new_distance, dating, long_term, married_distant, friends, family |

## Example Usage

### Quick Activity Request

```
"We have 10 minutes before work. We need something quick and fun. We're not gamers."
```

### Full Date Night Planning

```
"We're 8 hours apart. She's in Singapore (early morning), I'm in London (evening).
We want a special date night this Saturday. We both love cooking and conversation.
Budget 90 minutes. How do we make this work?"
```

### Building a Weekly Ritual

```
"We want to move beyond random FaceTime calls. Help us create a weekly ritual
we'll actually stick to. We have varied schedules and are 3 hours apart.
We're 6 months into distance."
```

## Key Features

### Activity Categories

1. **Quick Touchpoints** (5-15 min) - 2 Truths & 1 Lie, Would You Rather, Photo Share
2. **Interactive Games** (30-60 min) - Skribbl.io, Codenames, Stardew Valley
3. **Creative Activities** (45-90 min) - Cooking together, Draw each other, Vision boards
4. **Passive Together Time** (60-120 min) - Watch parties, Sleep calls, Ambient connection
5. **Virtual Experiences** (60-180 min) - Museum tours, Escape rooms, Virtual concerts

### Troubleshooting Guides

- Video fatigue solutions
- Time zone challenge strategies
- Monotony breakers
- Technology backup plans

### Tools & Apps Directory

- Communication apps comparison
- Couples-specific apps (Paired, Between, Couple)
- Watch party apps (Teleparty, Discord, Rave)

## Verification

After installation, test with:

```
"What are some quick 10-minute activities for a long-distance couple who's tired of just chatting?"
```

Expected response should include:
- Multiple activity options
- Setup instructions
- Time estimates
- Why each activity builds connection

## Troubleshooting

### Skill Not Activating

Ensure you mention one of these trigger phrases:
- "long-distance relationship"
- "FaceTime activities"
- "video call date ideas"
- "LDR activities"
- "things to do together online"

### Generic Responses

If responses seem generic, provide more context:
- Available time
- Energy level
- What activities feel repetitive
- Time zone difference

---
Downloaded from [Find Skill.ai](https://findskill.ai)
