---
name: friend-debt-reminder
version: 1.0.0
---

# Friend Debt Reminder - Initialization

Get your money back from friends without ruining the friendship. This skill provides scripts, timing strategies, and app-based approaches that make repayment requests feel natural and drama-free.

## Structure

- `SKILL.md` - Main skill prompt with communication templates and psychology insights

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r friend-debt-reminder/ ~/.claude/skills/friend-debt-reminder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{amount_owed}}` | `$50` | The specific dollar amount your friend owes |
| `{{what_for}}` | `lunch last week` | What the money was originally for |
| `{{friend_name}}` | `friend` | Your friend's name |
| `{{payment_method}}` | `Venmo` | Preferred payment method (Venmo, PayPal, Zelle, Cash App) |
| `{{time_since_expense}}` | `a week` | How long ago the expense occurred |
| `{{relationship_closeness}}` | `casual friend` | How close you are (close friend, casual friend, coworker) |

## Quick Start

After installation, simply describe your situation:

> "My coworker friend owes me $75 from when I covered her portion of the group lunch two weeks ago. Help me ask without making work weird."

The skill will:
1. Assess your specific situation
2. Recommend the best communication channel (text, in-person, app)
3. Provide customized scripts with your exact details
4. Prepare you for common responses
5. Offer escalation strategies if needed

## Key Features

- **Text message templates** for casual, formal, and group situations
- **In-person scripts** for close friends you see regularly
- **App-based strategies** using Splitwise, Venmo, PayPal to remove awkwardness
- **Timing guidance** on when to ask (spoiler: sooner is always better)
- **Psychology insights** on why asking feels hard and why it shouldn't
- **Escalation paths** for friends who don't respond to first requests
- **Response templates** for handling defensive or apologetic replies

## When to Use This Skill

- Friend borrowed money and hasn't paid back
- You covered a group expense and need to collect
- Roommate owes for shared bills
- Coworker owes from lunch/coffee runs
- Old debt you've been avoiding bringing up
- Group trip expenses need settling

---
Downloaded from [Find Skill.ai](https://findskill.ai)
