---
name: first-date-vibe-check
version: 1.0.0
---

# First Date Vibe Check - Initialization

Non-obvious red flag screening questions and behavioral observation framework to identify relationship compatibility, emotional maturity, and potential toxic patterns before becoming emotionally invested.

## What This Skill Does

- Generates strategic screening questions that reveal character without feeling like an interview
- Teaches behavioral observation techniques for real-time date assessment
- Identifies concerning patterns through systematic analysis
- Distinguishes between love bombing and genuine romantic interest
- Assesses attachment styles, emotional maturity, and values alignment
- Provides post-date analysis frameworks and recommendations

## Structure

```
first-date-vibe-check/
├── SKILL.md    # Main skill prompt (copy to AI)
└── INIT.md     # This file
```

## Files to Generate

None (prompt-only skill)

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude skills directory
cp -r first-date-vibe-check/ ~/.claude/skills/first-date-vibe-check/
```

### ChatGPT / Custom GPT

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a system prompt or custom instructions

### Gemini

1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Paste at the beginning of your conversation

### Copilot

1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Use as a custom prompt or in Copilot Studio

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{vetting_depth}}` | `moderate` | Controls question intensity: light, moderate, or intensive screening |
| `{{red_flag_sensitivity}}` | `7` | Scale 1-10 for how strictly to interpret behaviors as red flags |
| `{{relationship_goal}}` | `long_term_serious` | What you're screening for: casual, long_term_serious, or marriage_focused |
| `{{attachment_style_priority}}` | `true` | Whether to incorporate attachment style assessment questions |
| `{{observation_focus}}` | `character_led` | Priority: attraction_first, values_first, character_led, or chemistry_first |

## Quick Start Examples

### Pre-Date Preparation

```
I have a first date this weekend with someone from a dating app. I'm looking
for something serious and long-term. Give me a list of 8-10 non-obvious
screening questions I can weave naturally into conversation that will help
me assess their emotional maturity, attachment style, and whether they're
genuinely ready for commitment—without making it feel like I'm interviewing them.
```

### Real-Time Date Assessment

```
I'm on a first date right now and I'm getting mixed signals. He seems very
into me—lots of compliments, constant texting interruptions for emergencies,
talking about a second date already—but he also got irritated when our
reservation was 10 minutes late and made a dismissive joke about the waiter.
Walk me through what I should be noticing for the rest of this date to
determine if this is love bombing red flag energy or just stress.
```

### Post-Date Analysis

```
After our date, I'm not sure how to feel. He was charming and we laughed a
lot, but I noticed three things: (1) he talked mostly about himself and his
accomplishments, (2) when I mentioned my ex had been unsupportive, he
immediately launched into trashing his ex for 10 minutes, and (3) he ordered
my food for me without asking what I wanted first. Are these red flags, or
am I reading too much into it?
```

## Key Features

### Red Flag Categories Covered

1. **Character & Integrity** - Honesty, accountability, treatment of others
2. **Emotional Maturity** - Self-awareness, emotional regulation, growth
3. **Attachment Style** - Avoidant, anxious, fearful-avoidant patterns
4. **Manipulation & Toxicity** - Love bombing, narcissism, boundary testing

### Green Flag Categories Covered

1. **Secure Attachment** - Consistency, respect, vulnerability balance
2. **Character Positives** - Kindness, curiosity, follow-through
3. **Emotional Health** - Self-awareness, healthy coping, empathy

### Workflows Included

1. **Real-Time First Date Assessment** - What to observe during the date
2. **Love Bombing vs. Genuine Interest** - Distinguishing manipulation from romance
3. **Post-Date Analysis Framework** - Structured reflection after dates
4. **Financial Compatibility Screening** - Indirect assessment of money attitudes

## Recommended Companion Skills

- **Assertive Communication Coach** - Express boundaries clearly
- **Emotional Regulation Coach** - Manage dating anxiety
- **Relationship Boundary Setter** - Establish healthy limits
- **Anxiety Spirals Interrupter** - Stop overthinking before dates

---
Downloaded from [Find Skill.ai](https://findskill.ai)
