---
name: breakup-logistics-manager
version: 1.0.0
---

# Breakup Logistics Manager - Initialization

Navigate the practical side of ending a cohabiting relationship with structured checklists for dividing assets, pet custody frameworks, lease termination strategies, and communication scripts.

## What This Skill Does

Transforms chaotic breakups into organized, fair separations by providing:
- **Asset Division Protocol** - Systematic inventory and fair market valuation
- **Pet Custody Framework** - Care-capacity-based ownership decisions
- **Lease Termination Advisor** - Options analysis and landlord communication templates
- **Communication Roadmap** - De-escalation scripts and documentation strategies
- **Mediation Preparation** - Documentation checklists and settlement templates
- **Security Checklist** - Protect documents, accounts, and records before separation

## Structure

```
breakup-logistics-manager/
├── SKILL.md      # Main skill prompt (copy to AI assistant)
└── INIT.md       # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code (Recommended)

```bash
# Copy skill to Claude Code skills directory
cp -r breakup-logistics-manager/ ~/.claude/skills/breakup-logistics-manager/
```

Then reference in conversations:
```
Use the breakup-logistics-manager skill to help me divide shared assets
```

### ChatGPT / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter block
3. Paste into a new conversation or custom GPT instructions
4. Start your session with your breakup logistics questions

## Variables

Customize behavior by specifying these when starting:

| Variable | Default | Options | Description |
|----------|---------|---------|-------------|
| `breakup_intensity` | `amicable` | amicable, neutral, contentious | Sets communication tone and formality |
| `asset_division_method` | `50-50` | 50-50, contribution-based, custom | How to split shared property |
| `pet_priority` | `care-capacity` | care-capacity, previous-owner, both-suitable | Pet custody decision framework |
| `lease_scenario` | `both-signatories` | both-signatories, one-owner, roommate-situation | Determines available lease options |
| `timeline_flexibility` | `standard-4weeks` | immediate, standard-4weeks, extended-8weeks | Separation timeline |
| `emotion_management_priority` | `medium` | low, medium, high | Emotional support integration level |

## Example Usage

**Scenario**: Couple ending 3-year cohabiting relationship with shared furniture, dog, and 8 months left on lease.

**Prompt**:
```
My partner and I are breaking up after living together for 3 years. We have:
- A sectional couch we paid $3,000 for together
- A dog we adopted together (I work from home, they travel monthly for work)
- 8 months left on our lease, neither can afford rent alone

We want to keep this civil. Where do I start?
```

**Expected Output**:
- Assessment of situation (amicable, shared assets, pet, lease)
- Priority action list for immediate steps
- Asset inventory template to complete
- Pet custody evaluation based on care capacity
- Lease termination options with pros/cons
- Communication scripts for discussing with partner and landlord

## Key Templates Included

1. **Asset Inventory Template** - Categorize furniture, electronics, kitchen items with market values
2. **Pet Custody Assessment** - Primary caregiver evaluation and future capacity comparison
3. **Lease Analysis Checklist** - Document all terms affecting termination
4. **Landlord Communication Template** - Professional lease termination request
5. **Asset Division Agreement** - Document final division with signatures
6. **Pet Ownership Agreement** - Transfer ownership with documentation
7. **Email Confirmation Template** - Memorialize verbal agreements
8. **Mediation Prep Folder** - Organize documentation for professional mediation

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Partner refuses to negotiate | Use mediation workflow; document all attempts |
| Can't agree on item values | Use Facebook Marketplace/eBay sold listings as evidence |
| Landlord won't negotiate | Check tenant rights in jurisdiction; offer to find replacement |
| Pet attachment vs. capacity conflict | Focus on pet's wellbeing; single ownership is better long-term |
| Contentious communication | Use written communication only; consider professional mediator |

## Related Skills

- **Assertive Communication Coach** - Scripts for difficult conversations
- **Moving Cost Optimizer** - Calculate relocation expenses
- **Budget Planner** - Plan post-breakup finances
- **Negotiation Stance Builder** - Develop negotiation strategies

## Not Suitable For

- Domestic violence/abuse situations (seek professional help, not logistics)
- Legal interpretation specific to your jurisdiction (consult attorney)
- Situations where one party refuses all engagement
- International separations with complex visa/residency implications

---
Downloaded from [Find Skill.ai](https://findskill.ai)
