---
name: apology-architect
version: 1.0.0
---

# Apology Architect - Initialization

Expert guidance for crafting genuine apologies that take full accountability without excuses. Uses psychology-backed frameworks (DBT, CBT, Gottman, NVC) to help repair relationships and rebuild trust.

## Structure

- `SKILL.md` - Main skill prompt with complete apology frameworks

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
cp -r apology-architect/ ~/.claude/skills/apology-architect/
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant as a system prompt or conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `relationship_type` | `personal` | Context: personal, professional, family, romantic, friendship |
| `harm_severity` | `moderate` | Scale: minor, moderate, severe (betrayal), repeated (pattern) |
| `time_elapsed` | `immediate` | When it happened: immediate, recent, delayed |
| `trust_status` | `damaged` | Current state: damaged, fractured, rebuilding, recovering |
| `apology_format` | `verbal` | Delivery: verbal, written, hybrid |
| `recipient_readiness` | `open` | Their openness: open, defensive, closed, unknown |

## Core Capabilities

### Frameworks Included
- **Seven-Part Apology Structure** - Complete framework with all elements
- **Three-Part Simplified Framework** - For less severe situations
- **Shame vs. Guilt Model** - Brene Brown's approach to healthy accountability
- **Red Flag Language Detection** - Identifies excuse-making patterns

### Workflows Included
1. **Personal Relationship Apology** - Romantic, family, close friends
2. **Workplace Apology** - Professional settings
3. **Deep Betrayal Apology** - Serious trust breaches
4. **Delayed/Late Apology** - Weeks/months later
5. **Repeated Behavior Apology** - Pattern acknowledgment

### Language Patterns Flagged
- "But" trap ("I'm sorry, BUT...")
- "If" deflection ("I'm sorry IF you felt...")
- Non-apology apology ("I'm sorry you feel that way")
- Excuse masquerading as context ("I didn't mean to...")
- Self-pity trap ("I feel so terrible...")

## Example Usage

```
I snapped at my partner last night during an argument and said something
hurtful about their family. They've been distant since. Help me craft a
genuine apology that takes full responsibility without making excuses
about being stressed from work.
```

## Key Concepts

- **Accountability vs. Blame-Shifting** - Own it completely
- **Impact vs. Intention** - Focus on what happened, not what you meant
- **Forgiveness Expectation Release** - Apology doesn't obligate forgiveness
- **Trust Restoration Timeline** - Rebuilding takes consistent behavior over time
- **Non-Defensive Listening** - Hear their response without defending

## Best Practices

### DO
- Be specific about what you did
- Use "I" statements
- Acknowledge their emotions
- Outline concrete changes
- Give them space to respond

### DON'T
- Use "but," "if," or "however"
- Blame circumstances
- Make it about your feelings
- Expect immediate forgiveness
- Apologize to manipulate

---

Downloaded from [Find Skill.ai](https://findskill.ai)
