---
name: anniversary-gift-brainstormer
version: 1.0.0
---

# Initialization

Generate thoughtful anniversary gift ideas based on your partner's obscure hobbies and niche interests. This skill moves beyond generic gift lists to conduct structured discovery conversations and provide deeply personalized recommendations.

## What This Skill Does

- **Obscure Hobby Excavation**: Deep questioning to uncover non-obvious interests
- **Adjacent Hobby Discovery**: Finds complementary activities to extend existing passions
- **Budget-Aware Personalization**: Scales recommendations from $20 to $500+
- **Relationship Context Integration**: Considers milestone significance and personality
- **Specificity Engine**: Provides exact products, retailers, and sourcing guidance
- **Avoidance Algorithm**: Identifies what NOT to suggest based on context

## Structure

```
anniversary-gift-brainstormer/
├── SKILL.md    # Main skill prompt (copy this to your AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
# Copy to Claude Code skills directory
cp -r anniversary-gift-brainstormer/ ~/.claude/skills/anniversary-gift-brainstormer/
```

Then reference in conversations:
```
Use skill anniversary-gift-brainstormer
```

### ChatGPT / Claude.ai / Gemini / Copilot

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or at the start of conversation

### Custom GPT / Claude Project

1. Open `SKILL.md`
2. Copy the entire content
3. Add to Custom Instructions or Project Knowledge

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `hobby_obscurity_level` | `moderate` | How niche is the hobby: common, niche, obscure |
| `budget_amount` | `150` | Gift budget in USD |
| `relationship_milestone` | `regular` | Anniversary type: 1st, 5th, 10th, 25th, 50th, regular |
| `gift_giver_involvement` | `moderate` | Time/learning giver will invest: minimal, moderate, high |
| `recipient_personality` | `balanced` | Minimalist, collector, experiential, practical, adventurous |
| `consumable_weight` | `balanced` | Preference: consumable_only, consumable_heavy, balanced, durable_heavy |
| `sourcing_preference` | `mixed` | Where to source: indie_creators, specialty_retailers, mixed, amazon_only |
| `surprise_level` | `moderate` | complete_surprise, collaborative, hints_preferred |

## Example Usage

**Quick start prompt:**
```
My wife has been really into fountain pens for the last year - she has a whole spreadsheet of inks, visits pen shows, and writes with them daily. We're celebrating our 7th anniversary and I have a $200 budget. She already has decent beginner pens but keeps talking about 'making the leap' to an expensive one. She's also mentioned being interested in calligraphy but hasn't started. Can you help me find something thoughtful?
```

**Budget-focused prompt:**
```
I need anniversary gift ideas for my husband who's obsessed with geocaching. Budget is $100-150, and he's been doing it seriously for about 8 months. What should I look for?
```

**Adjacent hobby prompt:**
```
My partner is really into mechanical keyboard building. For our 10th anniversary, I want to either go deeper into that hobby or find something adjacent they might enjoy. What are my options?
```

## Customization Tips

### For Specific Hobby Types

Add context about the hobby community:
```
My partner is into [hobby]. The community seems to value [quality/rarity/craftsmanship/experiences]. They follow [influencers/forums/subreddits]. What would impress someone in this community?
```

### For Milestone Anniversaries

Reference traditional anniversary themes:
```
This is our 5th anniversary (traditionally wood). How can I incorporate that theme into a gift related to their [hobby] interest?
```

### For Budget Constraints

Be specific about flexibility:
```
Budget is firm at $75. I'd rather get one thoughtful item than several mediocre ones. What's the best single gift for someone into [hobby]?
```

## Key Features

1. **Discovery Workflow**: Structured questions before suggesting (not generic lists)
2. **Hobby Adjacencies**: Maps related activities for expansion ideas
3. **Tiered Recommendations**: Different items at each budget level
4. **Sourcing Guidance**: Specific retailers, creators, and platforms
5. **Red Flag Checks**: Warns about potential duplicates or mismatches
6. **Relationship Context**: Considers milestone significance and personality

## Troubleshooting

**"I don't know their exact hobby"**
- Describe what they spend time on, even vaguely
- Mention their browser tabs, YouTube channels, or recent purchases
- The skill will ask clarifying questions

**"Suggestions seem too generic"**
- Provide more depth indicators (time/money invested, skill level)
- Mention specific products they already own
- Describe their personality (minimalist vs. collector)

**"Can't find the recommended items"**
- Ask for alternative sourcing options
- Request items available on major retailers
- Consider experience gifts instead

## Related Skills

- **Gift Idea Generator**: General-purpose gift recommendations
- **Brainstorming Assistant**: Creative ideation techniques
- **Budget Planner**: Plan gift budgets across recipients
- **Long Distance Activity Picker**: Shared couple activities

---
Downloaded from [Find Skill.ai](https://findskill.ai)
