---
name: real-estate-marketing-coach
version: 1.0.0
---

# Real Estate Marketing Coach - Initialization

Transform property listings into multi-channel marketing campaigns with SEO-optimized descriptions, drip campaigns, lead magnets, and personalized follow-ups that convert leads into closed deals.

## What This Skill Does

- Generates SEO-optimized listing descriptions for MLS and websites
- Creates multi-channel content (social media, email, video scripts) from single listing
- Designs lead magnets (buyer guides, market reports) for lead capture
- Writes email drip campaigns for buyer/seller nurture
- Produces personalized follow-up correspondence
- Maintains Fair Housing Act compliance in all content

## Structure

```
real-estate-marketing-coach/
├── SKILL.md      # Main skill prompt (copy into AI assistant)
└── INIT.md       # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r real-estate-marketing-coach/ ~/.claude/skills/real-estate-marketing-coach/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or system prompt
4. Start with a property listing or marketing request

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{property_type}}` | `single-family home` | Type of property (condo, townhome, multi-family, commercial, luxury) |
| `{{buyer_persona}}` | `first-time buyers` | Target audience (move-up families, downsizers, investors, luxury buyers) |
| `{{tone}}` | `professional but warm` | Brand voice (casual, playful, luxury, neighborly, expert-authority) |
| `{{location_focus}}` | `` | Specific neighborhood + city for hyperlocal keywords |
| `{{marketing_channel}}` | `email` | Target platform (MLS, Facebook, Instagram, LinkedIn, print) |

## Quick Start Examples

### Create a Just Listed Campaign

```
Create a complete marketing campaign for my new listing:
- 4-bed, 3-bath renovated colonial in Highlands, Denver
- $725,000
- Features: chef's kitchen, home office, finished basement, large fenced backyard
- Target: move-up families with children ages 5-15

I need:
1. MLS description
2. Instagram carousel (5 slides)
3. Email announcement
4. 3-email follow-up sequence for open house attendees
```

### Generate Lead Magnet

```
Create a first-time homebuyer guide for the Austin, Texas market.
Include:
- Pre-approval process with Texas lender options
- Down payment assistance programs
- Austin neighborhood overview (commute times, schools)
- Timeline from search to closing
- My contact info for free consultation CTA
```

### Write Personalized Follow-Up

```
Write a follow-up email for a buyer I showed a property to today:
- Client: Sarah and Mike
- Property: 123 Oak Street - 3-bed townhouse in Westlake
- What they loved: Open kitchen, walkable to their kids' school
- Concerns: Backyard is smaller than they hoped
- Timeline: Looking to move before school starts in August
```

### Create Open House Promo

```
Generate open house promotion for:
- Property: 456 Maple Ave - $550K renovated ranch
- Date: Saturday, March 15, 1-4pm
- Features: Updated kitchen, pool, corner lot
- Target: Young families and first-time buyers

I need:
1. 2-week social countdown (6 posts)
2. Email invitation
3. Door-hanger copy for neighbors
4. Post-event follow-up sequence
```

## Key Features

### Fair Housing Compliance
All content automatically avoids protected class references and uses inclusive language.

### AI Marker Avoidance
Eliminates clichés like "dream home," "stunning," and "must see" that signal AI-generated content.

### Platform Optimization
Content formatted specifically for each channel (character limits, hashtags, CTAs).

### Buyer Persona Targeting
Messaging tailored to specific audience segments with appropriate tone and focus points.

## Best Used With

- Property Listing Generator (MLS-compliant descriptions)
- Lead Magnet Ideator (strategic lead capture planning)
- Email Marketing Automation (drip campaign automation)
- Social Media Content Calendar (content planning)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
