---
name: weight-loss-fitness-coach
version: 1.0.0
description: Personal fitness and nutrition coach for weight loss, meal planning, and workout programming
author: FindSkill.ai
license: MIT
---

# Initialization

This skill transforms AI into a personal fitness and nutrition coach that creates customized meal plans and workout routines based on your specific goals, equipment, schedule, and preferences.

## Overview

**What this skill does:**
- Calculates personalized calorie and macro targets
- Creates custom meal plans based on preferences and restrictions
- Designs workout programs for your equipment and schedule
- Provides progress tracking templates and adjustment protocols
- Offers ongoing accountability and coaching support

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
weight-loss-fitness-coach/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None (prompt-only skill)

## Files to Generate

None - this is a prompt-only skill. Copy SKILL.md content directly to your AI assistant.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r weight-loss-fitness-coach/ ~/.claude/skills/weight-loss-fitness-coach/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Optionally: Create a dedicated "Fitness Coach" thread for context retention

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_weight}}` | "" | Current weight in lbs or kg |
| `{{goal_weight}}` | "" | Target weight |
| `{{available_equipment}}` | "bodyweight" | Equipment access |
| `{{dietary_restrictions}}` | "none" | Food allergies or preferences |
| `{{workout_days}}` | "3-4" | Days per week available |

## Example Usage

**Initial assessment:**
> "I'm 185 lbs, 5'10", male, 35 years old. Goal is 165 lbs. I have a gym membership and can work out 4 days a week for about an hour. I want to lose fat while keeping muscle. No food restrictions but I hate cooking complicated meals. Help me create a meal and workout plan."

**Weekly check-in:**
> "Weekly check-in: Started at 185, now 183.5 after 2 weeks. Energy is good (7/10). Completed all 4 workouts. Hit protein target most days but struggled on weekends. Feeling motivated but hungry in the afternoons."

**Plan adjustment:**
> "I've been stuck at 175 for 3 weeks now. Following the plan 90% of the time. What should I adjust?"

**Meal swap request:**
> "I'm getting bored of chicken. What are some other high-protein options that are easy to prep?"

## Key Features

1. **Evidence-based calculations** - Mifflin-St Jeor BMR, TDEE multipliers
2. **Flexible meal planning** - Templates that adapt to your preferences
3. **Progressive workout programming** - Structured overload for results
4. **Plateau protocols** - Step-by-step adjustment when progress stalls
5. **Accountability system** - Weekly check-in templates
6. **Practical focus** - Meal prep friendly, time-efficient workouts

## Best Practices

For best results:

1. **Create a dedicated thread** - Keeps context and progress history
2. **Be specific with stats** - More detail = more personalized plans
3. **Check in weekly** - Regular updates allow for timely adjustments
4. **Track honestly** - Under-reporting food sabotages progress
5. **Ask questions** - Understanding "why" builds lasting habits

## Success Patterns from Research

Based on documented AI-assisted fitness journeys:
- Users report weight loss of 1 lb/week on average
- Personalized plans outperform generic programs
- Accountability check-ins improve adherence
- Context retention in dedicated threads improves recommendations

## Verification

To verify the skill is working correctly:
1. Share your basic stats and goals
2. Confirm you receive calculated calorie/macro targets
3. Confirm you get a structured workout plan
4. Confirm meal suggestions match your stated preferences

---

Downloaded from [FindSkill.ai](https://findskill.ai)
