---
name: webinar-agenda-builder
version: 1.0.0
---

# Webinar Agenda Builder - Initialization

Create time-blocked webinar agendas with slide outlines, engagement elements, and platform-specific optimization for maximum audience retention. Prevents the 15-minute attention drop-off with strategically placed interactive elements.

## Package Structure

```
webinar-agenda-builder/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Initialization Steps

### For Claude Code

```bash
# Copy to Claude Code skills directory
cp -r webinar-agenda-builder/ ~/.claude/skills/webinar-agenda-builder/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{webinar_topic}}` | Your webinar topic | Main subject of the webinar |
| `{{duration_minutes}}` | 60 | Total duration (30, 45, 60, 75, 90 minutes) |
| `{{platform}}` | Zoom | Webinar platform (Zoom, Webex, Teams, GoToWebinar, ON24, Livestorm) |
| `{{audience_type}}` | B2B professionals | Primary audience segment |
| `{{primary_goal}}` | Lead generation | Main outcome (lead gen, training, product launch, thought leadership) |
| `{{speaker_count}}` | 1 | Number of speakers (1, 2-3 panel, 4+ symposium) |

## Example Usage

```
I'm hosting a 60-minute product launch webinar for B2B SaaS prospects.
Expected attendance is 150+ people on Zoom. I want to demo the product
for about 20 minutes and drive attendees to book sales demos. Create an
agenda with engagement elements that prevents the 15-minute attention drop.
```

## Capabilities

1. **Agenda Structure Generation** - Time-blocked agendas for 30-120 minutes
2. **Slide Outline Creation** - Visual progression with speaker notes
3. **Engagement Element Mapping** - Strategic poll, Q&A, and interaction placement
4. **Time Allocation Optimization** - Realistic timing based on content depth
5. **Platform-Specific Configuration** - Zoom, Webex, GoToWebinar, ON24, Livestorm optimization
6. **Visual Design Framework** - Typography, color, and layout recommendations
7. **Post-Webinar Strategy** - Follow-up sequences and content repurposing

## Format Templates Included

- Single-Speaker Educational (45-60 min)
- Multi-Speaker Panel Discussion (60-75 min)
- Product Launch/Demo Webinar (60-75 min)
- Training/Certification Series (90 min/session)
- Nonprofit Fundraising/Impact (45-55 min)

## Output Includes

- Time-blocked agenda with speaker notes
- Slide outline (title, bullets, notes per slide)
- Engagement plan with timing
- Platform setup checklist
- Post-webinar email sequence

## Key Concepts

- **Attention Curve**: Audience attention drops at 15-20 min mark - engagement prevents drop-off
- **80/20 Rule**: 80% content, 20% interaction distributed throughout
- **Platform Optimization**: Leverage native features (polls, breakouts, reactions)

---

Downloaded from [Find Skill.ai](https://findskill.ai)
