---
name: vendor-contract-negotiator
version: 1.0.0
---

# Vendor Contract Negotiator - Initialization

Generate strategic counteroffers and negotiation talking points for vendor agreements using BATNA/ZOPA analysis, leverage identification, and integrative bargaining frameworks.

## What This Skill Does

This skill transforms you into an expert procurement strategist who helps users:
- Calculate BATNA (Best Alternative to Negotiated Agreement) and ZOPA (Zone of Possible Agreement)
- Generate multi-option counteroffers with elegant negotiables
- Create specific talking points and response scripts for vendor conversations
- Analyze contract clauses for risk and suggest protective alternatives
- Identify and activate leverage points in vendor relationships

## Package Structure

```
vendor-contract-negotiator/
├── SKILL.md      # Main skill prompt (copy to your AI assistant)
├── INIT.md       # This initialization file
└── vendor-contract-negotiator.zip  # Complete package
```

## Files to Generate

None (prompt-only skill)

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude skills directory
cp -r vendor-contract-negotiator/ ~/.claude/skills/vendor-contract-negotiator/
```

Then reference in your project's `CLAUDE.md`:
```markdown
## Available Skills
- `vendor-contract-negotiator` - Generate counteroffers and negotiation talking points for vendor agreements
```

### ChatGPT / GPT-4

1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (after the second `---`)
3. Paste into ChatGPT as your initial prompt
4. Begin your negotiation request

### Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy the full skill content
3. Paste into your AI assistant
4. Start with your negotiation scenario

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{negotiation_style}}` | `integrative` | Choose `integrative` (win-win) or `distributive` (zero-sum) |
| `{{risk_tolerance}}` | `moderate` | Set to `low`, `moderate`, or `high` |
| `{{budget_flexibility}}` | `10%` | Percentage of budget willing to exceed |
| `{{contract_term_preference}}` | `2-year` | Preferred contract length |
| `{{vendor_relationship_stage}}` | `new` | Set to `new`, `renewal`, or `strategic` |
| `{{priority_items}}` | `price,sla,term` | Top negotiation priorities |

## Quick Start

After installing, try this prompt:

```
I'm negotiating a renewal with our SaaS vendor. Their proposal:
- $150K/year (10% increase)
- 1-year term
- 99.5% uptime SLA
- Auto-renewal with 30-day notice

My budget ceiling is $135K, but I'd accept $140K for a multi-year
deal with better SLA. I have a competing quote at $130K.

Generate:
1. A counteroffer with 2-3 options
2. My BATNA/ZOPA analysis
3. Talking points for the negotiation call
4. Response scripts for common pushback
```

## Key Frameworks Included

### BATNA (Best Alternative to Negotiated Agreement)
- Calculate your walk-away power
- Improve alternatives before negotiating
- Never accept terms worse than BATNA

### ZOPA (Zone of Possible Agreement)
- Estimate overlap between your max and vendor's min
- No ZOPA = no deal possible
- Focus negotiation within the zone

### Elegant Negotiables
- Low-cost concessions (to you) that vendors value highly
- Examples: case studies, longer terms, volume commitments
- Use to unlock price or terms flexibility

### Contract Risk Traffic Light
- RED: Deal-breakers (unlimited liability, no termination rights)
- YELLOW: Must negotiate (weak SLAs, short notice periods)
- GREEN: Generally acceptable (mutual NDAs, standard caps)

## Output Formats

The skill generates structured outputs including:
- BATNA/ZOPA Analysis tables
- Multi-option counteroffers
- Leverage scorecards
- Talking point guides with specific language
- Pushback response scripts
- Contract clause recommendations

## Best Used For

- SaaS/software contract renewals
- Professional services agreements
- Manufacturing/supply chain negotiations
- Consulting and advisory contracts
- Technology vendor relationships
- Multi-year enterprise agreements

## Limitations

- Does not provide legal advice (recommend attorney review for complex clauses)
- Cannot guarantee specific negotiation outcomes
- Requires user to provide vendor proposal and constraints
- Market benchmarks are illustrative—verify with current data

---
Downloaded from [Find Skill.ai](https://findskill.ai)
