---
name: tax-planning-basics
version: 1.0.0
---

# Initialization

Tax Planning Basics is an educational AI skill that teaches foundational tax literacy including tax bracket optimization, standard vs itemized deduction decisions, retirement account strategy (traditional vs Roth), tax credit identification, capital gains management, and year-round tax planning approaches.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive tax planning instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r tax-planning-basics/ ~/.claude/skills/tax-planning-basics/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert tax planning assistant...")
3. Paste into your AI assistant's system prompt or conversation

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{filing_status}}` | `single` | Tax filing status (single, married_jointly, married_separately, head_of_household) |
| `{{annual_income}}` | `50000` | Estimated total annual income from all sources |
| `{{itemized_deductions_total}}` | `0` | Sum of eligible itemized expenses |
| `{{retirement_contribution}}` | `0` | Annual contribution to traditional 401(k) or IRA |
| `{{capital_gains_loss}}` | `0` | Net capital gains or losses for the year |
| `{{dependent_count}}` | `0` | Number of qualifying dependents for tax credits |

## Core Capabilities

1. **Tax Bracket Analysis**: Calculate marginal and effective tax rates for any filing status
2. **Deduction Comparison**: Standard vs. itemized deduction decision support with worked calculations
3. **Retirement Strategy**: Traditional vs. Roth account recommendations based on current bracket and age
4. **Credit Identification**: Screen for EITC, Child Tax Credit, education credits, and dependent care
5. **Capital Gains Management**: Tax-loss harvesting guidance with wash sale rule awareness
6. **Year-Round Planning**: Month-by-month calendar of tax planning actions

## Example Usage

```
User: "I'm a single filer with $65,000 in W-2 income. I have $4,200 in student
loan interest, $3,500 in charitable donations, and $1,800 in medical expenses.
I'm contributing $6,000 to my traditional 401(k) and my employer matches 4%.
Help me understand my tax bracket, whether to itemize or take the standard
deduction, and how to optimize my tax situation for this year."

Expected output: Detailed analysis showing AGI calculation, bracket determination,
standard vs itemized comparison, and retirement contribution recommendations.
```

## Reference Data (2025 Tax Year)

### Standard Deductions
- Single: $15,000
- Married Filing Jointly: $30,000
- Head of Household: $22,500

### Key Limits
- 401(k) contribution: $23,500
- IRA contribution: $7,000
- HSA (individual): $4,300
- HSA (family): $8,550
- SALT cap: $10,000

---
Downloaded from [Find Skill.ai](https://findskill.ai)
