---
name: tax-deduction-auditor
version: 1.0.0
---

# Initialization

Review business deductions for IRS audit risk. Flag questionable expenses, identify missing documentation, and get compliance recommendations before filing.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with risk classification system, deduction category rules, and output templates

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r tax-deduction-auditor/ ~/.claude/skills/tax-deduction-auditor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{business_type}}` | `freelance` | Type of business for industry-specific guidance |
| `{{filing_status}}` | `single` | Tax filing status |
| `{{risk_tolerance}}` | `moderate` | Aggressiveness level |
| `{{tax_year}}` | `2024` | Tax year being reviewed |
| `{{annual_income}}` | `75000` | Approximate annual business income |

## Key Features

- **Risk Classification**: Safe, Medium Risk, High Risk, Not Deductible categories
- **IRS Rule Citations**: Publication 535, 587, 463 references
- **Audit Trigger Thresholds**: Know red flag ratios
- **Documentation Checklists**: What you need to substantiate each deduction
- **Penalty Exposure**: Understand audit consequences

## Example Usage

> Review these deductions for audit risk. I'm a freelance consultant with $95,000 income: Home office $6,000, Internet $960 (80% business), Meals $3,200, Car mileage 8,000 miles, Gym $720, Hawaii trip $4,500 (3-day conference, 4 days leisure). Which are risky?

---
Downloaded from [Find Skill.ai](https://findskill.ai)
